/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.toolbutton;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiToolButton;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;

public class ToolButton
extends AbstractComponent {
    public final Event<Void> onDropDownOpened = new Event();
    private Icon icon;
    private String popoverText;
    private boolean grayOutIfNotHovered;
    private boolean openDropDownIfNotSet = false;
    private Component dropDownComponent;
    private Integer minDropDownWidth = 300;
    private Integer minDropDownHeight = 300;
    public final Event<Void> onClick = new Event();

    public ToolButton(Icon icon) {
        this(icon, null, null);
    }

    public ToolButton(Icon icon, String popoverText) {
        this(icon, popoverText, null);
    }

    public ToolButton(Icon icon, String popoverText, Component dropDownComponent) {
        this.icon = icon;
        this.popoverText = popoverText;
        this.dropDownComponent = dropDownComponent;
    }

    public boolean isGrayOutIfNotHovered() {
        return this.grayOutIfNotHovered;
    }

    public void setGrayOutIfNotHovered(boolean grayOutIfNotHovered) {
        this.grayOutIfNotHovered = grayOutIfNotHovered;
    }

    @Override
    public UiComponent createUiComponent() {
        String icon = this.getSessionContext().resolveIcon(this.icon);
        UiToolButton uiToolButton = new UiToolButton(icon, this.popoverText);
        this.mapAbstractUiComponentProperties((UiComponent)uiToolButton);
        uiToolButton.setGrayOutIfNotHovered(this.grayOutIfNotHovered);
        uiToolButton.setDropDownComponent(this.dropDownComponent != null ? this.dropDownComponent.createUiComponentReference() : null);
        uiToolButton.setMinDropDownWidth(this.minDropDownWidth != null ? this.minDropDownWidth : 0);
        uiToolButton.setMinDropDownHeight(this.minDropDownHeight != null ? this.minDropDownHeight : 0);
        uiToolButton.setMinDropDownHeight(this.minDropDownHeight.intValue());
        return uiToolButton;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TOOL_BUTTON_CLICKED: {
                this.onClick.fire(null);
                break;
            }
            case UI_BUTTON_DROP_DOWN_OPENED: {
                this.onDropDownOpened.fire(null);
            }
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.queueCommandIfRendered(() -> new UiToolButton.SetIconCommand(this.getId(), this.getSessionContext().resolveIcon(icon)));
    }

    public String getPopoverText() {
        return this.popoverText;
    }

    public void setPopoverText(String popoverText) {
        this.popoverText = popoverText;
        this.queueCommandIfRendered(() -> new UiToolButton.SetPopoverTextCommand(this.getId(), popoverText));
    }

    public boolean isOpenDropDownIfNotSet() {
        return this.openDropDownIfNotSet;
    }

    public void setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
        this.openDropDownIfNotSet = openDropDownIfNotSet;
        this.queueCommandIfRendered(() -> new UiToolButton.SetOpenDropDownIfNotSetCommand(this.getId(), openDropDownIfNotSet));
    }

    public Component getDropDownComponent() {
        return this.dropDownComponent;
    }

    public void setDropDownComponent(Component dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        this.queueCommandIfRendered(() -> new UiToolButton.SetDropDownComponentCommand(this.getId(), dropDownComponent != null ? dropDownComponent.createUiComponentReference() : null));
    }

    public Integer getMinDropDownWidth() {
        return this.minDropDownWidth;
    }

    public void setMinDropDownWidth(Integer minDropDownWidth) {
        this.minDropDownWidth = minDropDownWidth;
        this.queueCommandIfRendered(() -> new UiToolButton.SetDropDownSizeCommand(this.getId(), minDropDownWidth.intValue(), this.minDropDownHeight.intValue()));
    }

    public Integer getMinDropDownHeight() {
        return this.minDropDownHeight;
    }

    public void setMinDropDownHeight(Integer minDropDownHeight) {
        this.minDropDownHeight = minDropDownHeight;
        this.queueCommandIfRendered(() -> new UiToolButton.SetDropDownSizeCommand(this.getId(), this.minDropDownWidth.intValue(), minDropDownHeight.intValue()));
    }

    @Override
    protected void doDestroy() {
        if (this.dropDownComponent != null) {
            this.dropDownComponent.destroy();
        }
    }
}

