/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.forcelayout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.event.Event;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutLink;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutNode;
import org.teamapps.ux.component.charting.forcelayout.GraphChangeOperation;
import org.teamapps.ux.component.charting.forcelayout.LinkId;

public class ForceLayoutModel<RECORD> {
    public Event<GraphChangeOperation<RECORD>> onNodesAdded = new Event();
    public Event<GraphChangeOperation<RECORD>> onNodesRemoved = new Event();
    private final List<ForceLayoutNode<RECORD>> displayedNodes = new ArrayList<ForceLayoutNode<RECORD>>();
    private final List<ForceLayoutLink<RECORD>> displayedLinks = new ArrayList<ForceLayoutLink<RECORD>>();
    private final Map<RECORD, ForceLayoutNode<RECORD>> graphNodeByNode = new HashMap<RECORD, ForceLayoutNode<RECORD>>();
    private final Set<RECORD> availableNodes = new HashSet<RECORD>();
    private final Set<LinkId<RECORD>> availableLinks = new HashSet<LinkId<RECORD>>();

    public boolean containsNode(RECORD record) {
        return this.availableNodes.contains(record);
    }

    public boolean containsNode(RECORD record, GraphChangeOperation<RECORD> changeOperation) {
        return this.getGraphNode(record, changeOperation) != null;
    }

    public boolean containsLink(RECORD node1, RECORD node2) {
        return this.availableLinks.contains(this.getLinkId(node1, node2));
    }

    public void removeAll() {
        this.onNodesRemoved.fire(new GraphChangeOperation<RECORD>(this.displayedNodes, this.displayedLinks, true));
        this.availableNodes.clear();
        this.availableLinks.clear();
        this.displayedLinks.clear();
        this.displayedNodes.clear();
        this.graphNodeByNode.clear();
    }

    public void applyChange(GraphChangeOperation<RECORD> changeOperation) {
        if (changeOperation.containsAddOperations()) {
            changeOperation.getAddedLinks().forEach(link -> this.availableLinks.add(this.getLinkId(link.getSource().getRecord(), link.getTarget().getRecord())));
            changeOperation.getAddedNodes().forEach(graphNode -> {
                Object record = graphNode.getRecord();
                this.graphNodeByNode.put(record, (ForceLayoutNode<RECORD>)graphNode);
                this.availableNodes.add(record);
            });
            this.displayedNodes.addAll(changeOperation.getAddedNodes());
            this.displayedLinks.addAll(changeOperation.getAddedLinks());
            this.onNodesAdded.fire(changeOperation);
        }
        if (changeOperation.containsRemoveOperations()) {
            changeOperation.getRemovedLinks().forEach(link -> this.availableLinks.remove(this.getLinkId(link.getSource().getRecord(), link.getTarget().getRecord())));
            changeOperation.getRemovedNodes().forEach(graphNode -> {
                Object record = graphNode.getRecord();
                this.graphNodeByNode.remove(record);
                this.availableNodes.remove(record);
            });
            this.displayedNodes.removeAll(changeOperation.getRemovedNodes());
            this.displayedLinks.removeAll(changeOperation.getRemovedLinks());
            this.onNodesRemoved.fire(changeOperation);
        }
    }

    public ForceLayoutNode<RECORD> getGraphNode(RECORD record, GraphChangeOperation<RECORD> changeOperation) {
        ForceLayoutNode<RECORD> graphNode = this.graphNodeByNode.get(record);
        if (graphNode == null) {
            graphNode = changeOperation.getGraphNodeByNode().get(record);
        }
        return graphNode;
    }

    public void removeHigherLevels(ForceLayoutNode<RECORD> graphNode) {
        ArrayList<ForceLayoutLink<RECORD>> connectedLinks = new ArrayList<ForceLayoutLink<RECORD>>();
        HashSet<ForceLayoutNode<RECORD>> connectedNodes = new HashSet<ForceLayoutNode<RECORD>>();
        int level = graphNode.getLevel();
        this.getConnectedNodesAndLinks(graphNode, connectedLinks, connectedNodes, true, level);
        this.applyChange(new GraphChangeOperation<RECORD>(new ArrayList<ForceLayoutNode<RECORD>>(connectedNodes), connectedLinks, true));
    }

    private void getConnectedNodesAndLinks(ForceLayoutNode<RECORD> node, List<ForceLayoutLink<RECORD>> connectedLinks, Set<ForceLayoutNode<RECORD>> connectedNodes, boolean fullSubTree, int level) {
        List<ForceLayoutLink> links = this.displayedLinks.stream().filter(link -> link.getSource().equals(node) && link.getTarget().getLevel() > level || link.getTarget().equals(node) && link.getSource().getLevel() > level).collect(Collectors.toList());
        ArrayList nodes = new ArrayList();
        links.forEach(link -> {
            if (!link.getSource().equals(node)) {
                if (!connectedNodes.contains(link.getSource())) {
                    nodes.add(link.getSource());
                }
            } else if (!connectedNodes.contains(link.getTarget())) {
                nodes.add(link.getTarget());
            }
        });
        connectedLinks.addAll(links);
        connectedNodes.addAll(nodes);
        if (fullSubTree) {
            nodes.forEach(subNode -> this.getConnectedNodesAndLinks((ForceLayoutNode<RECORD>)subNode, connectedLinks, connectedNodes, true, level));
        }
    }

    public LinkId<RECORD> getLinkId(RECORD node1, RECORD node2) {
        return new LinkId<RECORD>(node1, node2);
    }
}

