/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map.shape;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.AbstractUiMapShape;
import org.teamapps.dto.AbstractUiMapShapeChange;
import org.teamapps.dto.UiMapLocation;
import org.teamapps.dto.UiMapPolyline;
import org.teamapps.dto.UiPolylineAppend;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.shape.AbstractMapShape;
import org.teamapps.ux.component.map.shape.ShapeProperties;

public class MapPolyline
extends AbstractMapShape {
    private List<Location> points;

    public MapPolyline(List<Location> points, ShapeProperties properties) {
        super(properties);
        this.points = new ArrayList<Location>(points);
    }

    public UiMapPolyline createUiMapShape() {
        UiMapPolyline uiPolyline = new UiMapPolyline();
        this.mapAbstractUiShapeProperties((AbstractUiMapShape)uiPolyline);
        uiPolyline.setPath(this.toUiMapLocations(this.points));
        return uiPolyline;
    }

    private List<UiMapLocation> toUiMapLocations(List<Location> locations) {
        return locations.stream().map(Location::createUiLocation).collect(Collectors.toList());
    }

    public MapPolyline addPoint(Location location) {
        return this.addPoints(List.of(location));
    }

    public MapPolyline addPoints(List<Location> points) {
        this.points.addAll(points);
        this.listener.handleShapeChanged(this, (AbstractUiMapShapeChange)new UiPolylineAppend(this.toUiMapLocations(points)));
        return this;
    }

    public List<Location> getPoints() {
        return this.points;
    }

    public void setPoints(List<Location> points) {
        this.points = points;
        this.listener.handleShapeChanged(this);
    }
}

