/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiResponsiveGridLayout;
import org.teamapps.dto.UiResponsiveGridLayoutPolicy;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.grid.layout.GridLayoutDefinition;

public class ResponsiveGridLayout
extends AbstractComponent {
    private final Map<Integer, GridLayoutDefinition> layoutDefinitionsByMinWidth = new HashMap<Integer, GridLayoutDefinition>();

    @Override
    public UiComponent createUiComponent() {
        List<UiResponsiveGridLayoutPolicy> layoutPolicies = this.createUiLayoutPolicies();
        UiResponsiveGridLayout uiResponsiveGridLayout = new UiResponsiveGridLayout(layoutPolicies);
        this.mapAbstractUiComponentProperties((UiComponent)uiResponsiveGridLayout);
        return uiResponsiveGridLayout;
    }

    private List<UiResponsiveGridLayoutPolicy> createUiLayoutPolicies() {
        return this.layoutDefinitionsByMinWidth.entrySet().stream().map(entry -> new UiResponsiveGridLayoutPolicy(((Integer)entry.getKey()).intValue(), ((GridLayoutDefinition)entry.getValue()).createUiGridLayout())).collect(Collectors.toList());
    }

    public void addLayoutPolicy(int minWidth, GridLayoutDefinition layout) {
        this.layoutDefinitionsByMinWidth.put(minWidth, layout);
        layout.getPlacements().stream().flatMap(placement -> placement.getComponents().stream()).forEach(component -> component.setParent(this));
        this.refreshLayout();
    }

    public void refreshLayout() {
        this.queueCommandIfRendered(() -> new UiResponsiveGridLayout.UpdateLayoutPoliciesCommand(this.getId(), this.createUiLayoutPolicies()));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }
}

