/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.databinding.ObservableValue;
import org.teamapps.databinding.TwoWayBindableValueImpl;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiTableClientRecord;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.record.EqualsAndHashCode;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.cache.record.RecordAndClientRecord;
import org.teamapps.ux.cache.record.RenderedRecordsCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.infiniteitemview.InfiniteListModel;
import org.teamapps.ux.component.infiniteitemview.RecordsAddedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsChangedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsRemovedEvent;

public abstract class AbstractInfiniteListComponent<RECORD, MODEL extends InfiniteListModel<RECORD>>
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final Event<ItemRange> onDisplayedRangeChanged = new Event();
    private final Consumer<Void> modelOnAllDataChangedListener = aVoid -> this.refresh();
    private final Consumer<RecordsAddedEvent<RECORD>> modelOnRecordsAddedListener = this::handleModelRecordsAdded;
    private final Consumer<RecordsChangedEvent<RECORD>> modelOnRecordsChangedListener = this::handleModelRecordsChanged;
    private final Consumer<RecordsRemovedEvent<RECORD>> modelOnRecordsDeletedListener = this::handleModelRecordsRemoved;
    private final TwoWayBindableValueImpl<Integer> count = new TwoWayBindableValueImpl<Integer>(0);
    private MODEL model;
    protected EqualsAndHashCode<RECORD> customEqualsAndHashCode = EqualsAndHashCode.bypass();
    protected RenderedRecordsCache<RECORD> renderedRecords = new RenderedRecordsCache();
    private ItemRange displayedRange = ItemRange.startEnd(0, 0);

    public AbstractInfiniteListComponent(MODEL model) {
        this.model = model;
    }

    public MODEL getModel() {
        return this.model;
    }

    public void setModel(MODEL model) {
        this.unregisterModelListeners();
        this.model = model;
        if (model != null) {
            this.preRegisteringModel(model);
            model.onAllDataChanged().addListener(this.modelOnAllDataChangedListener);
            model.onRecordsAdded().addListener(this.modelOnRecordsAddedListener);
            model.onRecordsChanged().addListener(this.modelOnRecordsChangedListener);
            model.onRecordsRemoved().addListener(this.modelOnRecordsDeletedListener);
        }
        this.refresh();
    }

    protected void preRegisteringModel(MODEL model) {
    }

    private void unregisterModelListeners() {
        this.model.onAllDataChanged().removeListener(this.modelOnAllDataChangedListener);
        this.model.onRecordsAdded().removeListener(this.modelOnRecordsAddedListener);
        this.model.onRecordsChanged().removeListener(this.modelOnRecordsChangedListener);
        this.model.onRecordsRemoved().removeListener(this.modelOnRecordsDeletedListener);
    }

    public void refresh() {
        this.count.set(-1);
        this.sendFullDisplayedRange();
    }

    private void sendFullDisplayedRange() {
        if (!this.isRendered()) {
            return;
        }
        List<RECORD> records = this.retrieveRecords(this.displayedRange.getStart(), this.displayedRange.getLength());
        UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(records);
        this.renderedRecords.clear();
        this.renderedRecords.addNoShift(this.displayedRange.getStart(), uiRecordMappingResult.recordAndClientRecords);
        this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
    }

    protected void handleScrollOrResize(ItemRange newRange) {
        this.onDisplayedRangeChanged.fire(newRange);
        ItemRange oldRange = this.displayedRange;
        this.displayedRange = newRange;
        LOGGER.debug("new displayedRange: {}", (Object)newRange);
        if (newRange.overlaps(oldRange)) {
            boolean recordsAdded;
            UiRecordMappingResult<RECORD> uiRecordMappingResult;
            List<RECORD> records;
            ArrayList<UiIdentifiableClientRecord> newUiRecords = new ArrayList<UiIdentifiableClientRecord>();
            boolean recordsRemoved = false;
            if (newRange.getStart() < oldRange.getStart()) {
                records = this.retrieveRecords(newRange.getStart(), oldRange.getStart() - newRange.getStart());
                uiRecordMappingResult = this.mapToClientRecords(records);
                this.renderedRecords.addNoShift(this.displayedRange.getStart(), uiRecordMappingResult.recordAndClientRecords);
                LOGGER.debug("newRange.start < oldRange.start: {} < {} so adding {} uiRecords", new Object[]{newRange, oldRange, uiRecordMappingResult.newUiRecords.size()});
                newUiRecords.addAll(uiRecordMappingResult.newUiRecords);
            } else if (newRange.getStart() > oldRange.getStart()) {
                this.renderedRecords.removeBeforeNoShift(newRange.getStart());
                recordsRemoved = true;
            }
            if (newRange.getEnd() > oldRange.getEnd()) {
                records = this.retrieveRecords(oldRange.getEnd(), newRange.getEnd() - oldRange.getEnd());
                uiRecordMappingResult = this.mapToClientRecords(records);
                this.renderedRecords.addNoShift(oldRange.getEnd(), uiRecordMappingResult.recordAndClientRecords);
                newUiRecords.addAll(uiRecordMappingResult.newUiRecords);
            } else if (newRange.getEnd() < oldRange.getEnd() && newRange.getEnd() < this.getModelCount()) {
                this.renderedRecords.removeAfterNoShift(newRange.getEnd());
                recordsRemoved = true;
            }
            boolean bl = recordsAdded = newUiRecords.size() > 0;
            if (recordsAdded || recordsRemoved) {
                this.updateClientRenderData(newUiRecords);
            }
        } else {
            LOGGER.debug("no overlap!");
            this.sendFullDisplayedRange();
        }
        LOGGER.debug("displayedRange after scroll update: {}; renderedRecords.size: {}", (Object)this.displayedRange, (Object)this.renderedRecords.size());
    }

    protected void handleModelRecordsAdded(RecordsAddedEvent<RECORD> changeEvent) {
        this.count.set(this.count.get() + changeEvent.getLength());
        if (!this.isRendered()) {
            return;
        }
        if (changeEvent.getStart() < this.displayedRange.getEnd()) {
            int newRecordsStartIndex = Math.max(changeEvent.getStart(), this.displayedRange.getStart());
            int newRecordsLength = Math.min(changeEvent.getLength(), Math.min(this.displayedRange.getEnd() - changeEvent.getStart(), this.displayedRange.getLength()));
            List<RECORD> newRecords = this.retrieveRecords(newRecordsStartIndex, newRecordsLength);
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(newRecords);
            this.renderedRecords.insertShifting(changeEvent.getStart(), uiRecordMappingResult.recordAndClientRecords);
            if (this.displayedRange.getLength() < this.renderedRecords.size()) {
                this.renderedRecords.removeNoShift(this.renderedRecords.getStartIndex() + this.displayedRange.getLength(), this.renderedRecords.getEndIndex());
            }
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    protected void handleModelRecordsChanged(RecordsChangedEvent<RECORD> changeEvent) {
        if (!this.isRendered()) {
            return;
        }
        if (changeEvent.getItemRange().overlaps(this.displayedRange)) {
            int queryStartIndex = Math.max(changeEvent.getStart(), this.displayedRange.getStart());
            int queryEndIndex = Math.min(changeEvent.getEnd(), this.displayedRange.getEnd());
            List changedRecords = changeEvent.getRecords().map(records -> records.subList(queryStartIndex - changeEvent.getStart(), queryEndIndex - changeEvent.getStart())).orElseGet(() -> this.retrieveRecords(queryStartIndex, queryEndIndex - queryStartIndex));
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(changedRecords);
            this.renderedRecords.removeNoShift(queryStartIndex, queryStartIndex + changedRecords.size());
            this.renderedRecords.addNoShift(queryStartIndex, uiRecordMappingResult.recordAndClientRecords);
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    protected void handleModelRecordsRemoved(RecordsRemovedEvent<RECORD> deleteEvent) {
        this.count.set(this.count.get() - deleteEvent.getLength());
        if (!this.isRendered()) {
            return;
        }
        if (deleteEvent.getStart() < this.displayedRange.getEnd()) {
            int removedRecordsStartIndex = Math.max(deleteEvent.getStart(), this.displayedRange.getStart());
            int removedRecordsLength = Math.min(deleteEvent.getLength(), Math.min(this.displayedRange.getEnd() - deleteEvent.getStart(), this.displayedRange.getLength()));
            int removeIndexInsideList = removedRecordsStartIndex - this.displayedRange.getStart();
            this.renderedRecords.removeNoShift(removedRecordsStartIndex, removedRecordsStartIndex + removedRecordsLength);
            List<RECORD> newRecords = this.retrieveRecords(this.displayedRange.getEnd() - removedRecordsLength, removedRecordsLength);
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(newRecords);
            this.renderedRecords.addNoShift(this.renderedRecords.getEndIndex(), uiRecordMappingResult.recordAndClientRecords);
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    protected void updateSingleRecordOnClient(RECORD record) {
        if (this.isRendered()) {
            UiTableClientRecord uiRecord = (UiTableClientRecord)this.renderedRecords.getUiRecord(record);
            int index = this.renderedRecords.getIndex(record);
            this.sendUpdateDataCommandToClient(index, this.renderedRecords.getUiRecordIds(), List.of(uiRecord), this.getModelCount());
        }
    }

    protected int getModelCount() {
        if (this.count.get() < 0) {
            this.count.set(this.model.getCount());
        }
        return this.count.get();
    }

    protected abstract List<RECORD> retrieveRecords(int var1, int var2);

    private void updateClientRenderData(List<UiIdentifiableClientRecord> newUiRecords) {
        LOGGER.debug("newUiRecords: {}", (Object)newUiRecords.size());
        this.sendUpdateDataCommandToClient(this.displayedRange.getStart(), this.renderedRecords.getUiRecordIds(), newUiRecords, this.getModelCount());
    }

    protected abstract void sendUpdateDataCommandToClient(int var1, List<Integer> var2, List<UiIdentifiableClientRecord> var3, int var4);

    private UiRecordMappingResult<RECORD> mapToClientRecords(List<RECORD> newRecords) {
        ArrayList<UiIdentifiableClientRecord> newUiRecords = new ArrayList<UiIdentifiableClientRecord>();
        ArrayList recordAndClientRecords = new ArrayList();
        for (RECORD r : newRecords) {
            boolean isNew;
            UiIdentifiableClientRecord existingUiRecord = this.renderedRecords.getUiRecord(r);
            UiIdentifiableClientRecord newUiRecord = this.createUiIdentifiableClientRecord(r);
            boolean bl = isNew = existingUiRecord == null || !existingUiRecord.getValues().equals(newUiRecord.getValues());
            if (isNew) {
                newUiRecords.add(newUiRecord);
            }
            recordAndClientRecords.add(new RecordAndClientRecord<RECORD>(r, isNew ? newUiRecord : existingUiRecord));
        }
        return new UiRecordMappingResult(recordAndClientRecords, newUiRecords);
    }

    protected abstract UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD var1);

    public ObservableValue<Integer> getCount() {
        return this.count;
    }

    public EqualsAndHashCode<RECORD> getCustomEqualsAndHashCode() {
        return this.customEqualsAndHashCode;
    }

    public void setCustomEqualsAndHashCode(EqualsAndHashCode<RECORD> customEqualsAndHashCode) {
        this.customEqualsAndHashCode = customEqualsAndHashCode;
        this.renderedRecords = new RenderedRecordsCache<RECORD>(customEqualsAndHashCode);
        this.refresh();
    }

    private static class UiRecordMappingResult<RECORD> {
        List<RecordAndClientRecord<RECORD>> recordAndClientRecords;
        List<UiIdentifiableClientRecord> newUiRecords;

        public UiRecordMappingResult(List<RecordAndClientRecord<RECORD>> recordAndClientRecords, List<UiIdentifiableClientRecord> newUiRecords) {
            this.recordAndClientRecords = recordAndClientRecords;
            this.newUiRecords = newUiRecords;
        }
    }
}

