/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.Objects;
import org.teamapps.dto.UiLongInterval;

public class Interval {
    private final long min;
    private final long max;

    public Interval(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public static Interval union(Interval interval, Interval intervalB) {
        return new Interval(Math.min(interval.getMin(), intervalB.getMin()), Math.max(interval.getMax(), intervalB.getMax()));
    }

    public static Interval intersection(Interval a, Interval b) {
        if (a.min < b.max && a.max > b.min) {
            return new Interval(Math.max(a.min, b.min), Math.min(a.max, b.max));
        }
        return Interval.empty();
    }

    public static Interval empty() {
        return new Interval(0L, 0L);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public UiLongInterval toUiLongInterval() {
        return new UiLongInterval(this.min, this.max);
    }

    public String toString() {
        return "Interval{min=" + this.min + ", max=" + this.max + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.min == interval.min && this.max == interval.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

