/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.uisession.TeamAppsSessionManager;
import org.teamapps.uisession.UiSession;
import org.teamapps.ux.servlet.ServletRequestListener;

public class LeaveBeaconServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRequestListener.class);
    private final TeamAppsSessionManager uiSessionManager;

    public LeaveBeaconServlet(TeamAppsSessionManager uiSessionManager) {
        this.uiSessionManager = uiSessionManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uiSessionId = IOUtils.toString((Reader)request.getReader());
        LOGGER.info("Got leaving beacon for teamapps session id: " + uiSessionId);
        UiSession uiSession = this.uiSessionManager.getUiSessionById(uiSessionId);
        if (uiSession != null) {
            uiSession.close(UiSessionClosingReason.TERMINATED_BY_CLIENT);
        }
    }
}

