/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.ux.session.ExecutionDecorator;

public class ExecutionDecoratorStack {
    private final List<ExecutionDecorator> decorators = Collections.synchronizedList(new ArrayList());

    public void addOuterDecorator(ExecutionDecorator decorator) {
        this.decorators.add(decorator);
    }

    public void addInnerDecorator(ExecutionDecorator decorator) {
        this.decorators.add(0, decorator);
    }

    public void removeDecorator(ExecutionDecorator decorator) {
        this.decorators.remove(decorator);
    }

    public void clear() {
        this.decorators.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable createWrappedRunnable(Runnable r) {
        if (this.decorators.isEmpty()) {
            return r;
        }
        List<ExecutionDecorator> list = this.decorators;
        synchronized (list) {
            Runnable outerRunnable = r;
            for (ExecutionDecorator decorator : this.decorators) {
                Runnable innerRunnable = outerRunnable;
                outerRunnable = () -> decorator.wrapExecution(innerRunnable);
            }
            return outerRunnable;
        }
    }
}

