/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import com.ibm.icu.util.ULocale;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.common.util.ExceptionUtil;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.ClientBackPressureInfo;
import org.teamapps.uisession.TeamAppsComponentNotFoundException;
import org.teamapps.uisession.TeamAppsUiApiException;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSession;
import org.teamapps.uisession.UiSessionActivityState;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.uisession.UiSessionState;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.popup.Popup;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.rootpanel.WakeLock;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.TemplateReference;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.i18n.ResourceBundleTranslationProvider;
import org.teamapps.ux.i18n.TranslationProvider;
import org.teamapps.ux.icon.IconBundle;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.json.UxJacksonSerializationTemplate;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.ExecutionDecorator;
import org.teamapps.ux.session.ExecutionDecoratorStack;
import org.teamapps.ux.session.FastLaneExecutionException;
import org.teamapps.ux.session.KeyboardEvent;
import org.teamapps.ux.session.Location;
import org.teamapps.ux.session.NavigationStateChangeEvent;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContextResourceManager;

public class SessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionContext.class);
    private static final String DEFAULT_BACKGROUND_NAME = "defaultBackground";
    private static final String DEFAULT_BACKGROUND_URL = "/resources/backgrounds/default-bl.jpg";
    private final ExecutorService sessionExecutor;
    public final Event<KeyboardEvent> onGlobalKeyEventOccurred = new Event();
    public final Event<NavigationStateChangeEvent> onNavigationStateChange = new Event();
    public final Event<UiSessionActivityState> onActivityStateChanged = new Event();
    public final Event<Void> onDestroyed = new Event();
    public final ExecutionDecoratorStack executionDecorators = new ExecutionDecoratorStack();
    private UiSessionState state = UiSessionState.ACTIVE;
    private final UiSession uiSession;
    private final ClientInfo clientInfo;
    private Location currentLocation;
    private final HttpSession httpSession;
    private final UxServerContext serverContext;
    private final SessionIconProvider iconProvider;
    private final UxJacksonSerializationTemplate uxJacksonSerializationTemplate;
    private final HashMap<String, ClientObject> clientObjectsById = new HashMap();
    private final SessionContextResourceManager sessionResourceProvider;
    private TranslationProvider translationProvider;
    private final Map<String, Template> registeredTemplates = new ConcurrentHashMap<String, Template>();
    private SessionConfiguration sessionConfiguration;
    private final Map<String, Icon<?, ?>> bundleIconByKey = new HashMap();
    private boolean defaultBackgroundRegistered;
    private Window sessionExpiredWindow;
    private Window sessionErrorWindow;
    private Window sessionTerminatedWindow;
    private final UiSessionListener uiSessionListener = new UiSessionListener(){

        @Override
        public void onUiEvent(String sessionId, UiEvent event) {
            SessionContext.this.runWithContext(() -> {
                String uiComponentId = event.getComponentId();
                if (uiComponentId != null) {
                    ClientObject clientObject = SessionContext.this.getClientObject(uiComponentId);
                    if (clientObject == null) throw new TeamAppsComponentNotFoundException(sessionId, uiComponentId);
                    clientObject.handleUiEvent(event);
                    return;
                } else {
                    SessionContext.this.handleStaticEvent(event);
                }
            });
        }

        @Override
        public void onUiQuery(String sessionId, UiQuery query, Consumer<Object> resultCallback) {
            SessionContext.this.runWithContext(() -> {
                String uiComponentId = query.getComponentId();
                ClientObject clientObject = SessionContext.this.getClientObject(uiComponentId);
                if (clientObject == null) {
                    throw new TeamAppsComponentNotFoundException(sessionId, uiComponentId);
                }
                Object result = clientObject.handleUiQuery(query);
                new UxJacksonSerializationTemplate(SessionContext.this).doWithUxJacksonSerializers(() -> resultCallback.accept(result));
            });
        }

        @Override
        public void onStateChanged(String sessionId, UiSessionState state) {
            SessionContext.this.runWithContext(() -> {
                boolean activityStateChanged = SessionContext.this.state.isActive() != state.isActive();
                SessionContext.this.state = state;
                if (state == UiSessionState.CLOSED) {
                    SessionContext.this.onDestroyed.fireIgnoringExceptions(null);
                    SessionContext.this.sessionExecutor.submit(SessionContext.this.sessionExecutor::shutdown);
                }
                if (activityStateChanged) {
                    SessionContext.this.onActivityStateChanged.fire(new UiSessionActivityState(state.isActive()));
                }
            });
        }
    };

    public SessionContext(UiSession uiSession, ExecutorService sessionExecutor, ClientInfo clientInfo, SessionConfiguration sessionConfiguration, HttpSession httpSession, UxServerContext serverContext, SessionIconProvider iconProvider) {
        this.sessionExecutor = sessionExecutor;
        this.uiSession = uiSession;
        this.httpSession = httpSession;
        this.clientInfo = clientInfo;
        this.currentLocation = clientInfo.getLocation();
        this.sessionConfiguration = sessionConfiguration;
        this.serverContext = serverContext;
        this.iconProvider = iconProvider;
        this.uxJacksonSerializationTemplate = new UxJacksonSerializationTemplate(this);
        this.translationProvider = new ResourceBundleTranslationProvider("org.teamapps.ux.i18n.DefaultCaptions", Locale.ENGLISH);
        this.addIconBundle(TeamAppsIconBundle.createBundle());
        this.runWithContext(this::updateSessionMessageWindows);
        this.sessionResourceProvider = new SessionContextResourceManager(uiSession.getSessionId());
    }

    public void pushNavigationState(String relativeUrl) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.PushHistoryStateCommand(relativeUrl));
    }

    public void navigateBack(int steps) {
        this.navigateForward(-steps);
    }

    public void navigateForward(int steps) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.NavigateForwardCommand(steps));
    }

    public static SessionContext current() {
        return CurrentSessionContext.get();
    }

    public static SessionContext currentOrNull() {
        return CurrentSessionContext.getOrNull();
    }

    public void setTranslationProvider(TranslationProvider translationProvider) {
        this.translationProvider = translationProvider;
    }

    public TranslationProvider getTranslationProvider() {
        return this.translationProvider;
    }

    public void addIconBundle(IconBundle iconBundle) {
        iconBundle.getEntries().forEach(entry -> this.bundleIconByKey.put(entry.getKey(), entry.getIcon()));
    }

    public Icon<?, ?> getIcon(String key) {
        return this.bundleIconByKey.get(key);
    }

    public ULocale getULocale() {
        return this.sessionConfiguration.getULocale();
    }

    public Locale getLocale() {
        return this.sessionConfiguration.getLocale();
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.sessionConfiguration.setULocale(locale);
        this.setConfiguration(this.sessionConfiguration);
    }

    public String getLocalized(String key, Object ... parameters) {
        return this.translationProvider.getLocalized(this.getLocale(), key, parameters);
    }

    public boolean isActive() {
        return this.state.isActive();
    }

    public UiSessionState getState() {
        return this.state;
    }

    public boolean isDestroyed() {
        return this.state == UiSessionState.CLOSED;
    }

    public void destroy() {
        this.destroy(UiSessionClosingReason.TERMINATED_BY_APPLICATION);
    }

    private void destroy(UiSessionClosingReason reason) {
        this.uiSession.close(reason);
    }

    public Event<Void> onDestroyed() {
        return this.onDestroyed;
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command, Consumer<RESULT> resultCallback) {
        if (CurrentSessionContext.get() != this) {
            String errorMessage = "Trying to queue a command for foreign/null SessionContext (CurrentSessionContext.get() != this). Please use SessionContext.runWithContext(Runnable). NOTE: The command will not get queued!";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Consumer<Object> wrappedCallback = resultCallback != null ? result -> this.runWithContext(() -> resultCallback.accept(result)) : null;
        this.uxJacksonSerializationTemplate.doWithUxJacksonSerializers(() -> this.uiSession.sendCommand(new UiCommandWithResultCallback(command, wrappedCallback)));
    }

    public void queueCommand(UiCommand<?> command) {
        this.queueCommand(command, null);
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public ClientBackPressureInfo getClientBackPressureInfo() {
        return this.uiSession.getClientBackPressureInfo();
    }

    public String createFileLink(File file) {
        return this.sessionResourceProvider.createFileLink(file);
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        return this.sessionResourceProvider.createResourceLink(resource, uniqueIdentifier);
    }

    public Resource getBinaryResource(int resourceId) {
        return this.sessionResourceProvider.getBinaryResource(resourceId);
    }

    public File getUploadedFileByUuid(String uuid) {
        return this.serverContext.getUploadedFileByUuid(uuid);
    }

    public TemplateReference registerTemplate(String id, Template template) {
        this.registeredTemplates.put(id, template);
        this.queueCommand((UiCommand<?>)new UiRootPanel.RegisterTemplateCommand(id, template.createUiTemplate()));
        return new TemplateReference(template, id);
    }

    public void registerTemplates(Map<String, Template> templates) {
        this.registeredTemplates.putAll(templates);
        this.queueCommand((UiCommand<?>)new UiRootPanel.RegisterTemplatesCommand(templates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Template)entry.getValue()).createUiTemplate()))));
    }

    public Template getTemplate(String id) {
        return this.registeredTemplates.get(id);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable) {
        return this.runWithContext(runnable, false);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable, boolean forceEnqueue) {
        return this.runWithContext(() -> {
            runnable.run();
            return null;
        }, forceEnqueue);
    }

    public <R> CompletableFuture<R> runWithContext(Callable<R> runnable) {
        return this.runWithContext(runnable, false);
    }

    public <R> CompletableFuture<R> runWithContext(Callable<R> callable, boolean forceEnqueue) {
        if (CurrentSessionContext.getOrNull() == this && !forceEnqueue) {
            try {
                return CompletableFuture.completedFuture(callable.call());
            }
            catch (Throwable t) {
                throw new FastLaneExecutionException("Exception during fast lane execution!", t);
            }
        }
        return CompletableFuture.supplyAsync(() -> {
            CurrentSessionContext.set(this);
            try {
                Object[] resultHolder = new Object[1];
                this.executionDecorators.createWrappedRunnable(() -> {
                    resultHolder[0] = ExceptionUtil.softenExceptions((Callable)callable);
                }).run();
                Object object = resultHolder[0];
                return object;
            }
            catch (Throwable t) {
                LOGGER.error("Exception while executing within session context", t);
                this.destroy(UiSessionClosingReason.SERVER_SIDE_ERROR);
                throw t;
            }
            finally {
                CurrentSessionContext.unset();
            }
        }, this.sessionExecutor);
    }

    public void addExecutionDecorator(ExecutionDecorator decorator, boolean outer) {
        if (outer) {
            this.executionDecorators.addOuterDecorator(decorator);
        } else {
            this.executionDecorators.addInnerDecorator(decorator);
        }
    }

    public void removeExecutionDecorator(ExecutionDecorator decorator) {
        this.executionDecorators.removeDecorator(decorator);
    }

    public void clearExecutionDecorators() {
        this.executionDecorators.clear();
    }

    public SessionConfiguration getConfiguration() {
        return this.sessionConfiguration;
    }

    public void setConfiguration(SessionConfiguration config) {
        this.sessionConfiguration = config;
        this.queueCommand((UiCommand<?>)new UiRootPanel.SetConfigCommand(config.createUiConfiguration()));
        this.updateSessionMessageWindows();
    }

    public void showPopupAtCurrentMousePosition(Popup popup) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.ShowPopupAtCurrentMousePositionCommand(popup.createUiReference()));
    }

    public void showPopup(Popup popup) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.ShowPopupCommand(popup.createUiReference()));
    }

    public ZoneId getTimeZone() {
        return this.sessionConfiguration.getTimeZone();
    }

    public SessionIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public <I extends Icon<I, S>, S> void setDefaultStyleForIconClass(Class<I> iconClass, S defaultStyle) {
        this.runWithContext(() -> this.iconProvider.setDefaultStyleForIconClass(iconClass, defaultStyle));
    }

    public String resolveIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return this.sessionConfiguration.getIconPath() + "/" + this.iconProvider.encodeIcon(icon, true);
    }

    public void registerClientObject(ClientObject clientObject) {
        CurrentSessionContext.throwIfNotSameAs(this);
        this.clientObjectsById.put(clientObject.getId(), clientObject);
    }

    public void unregisterClientObject(ClientObject clientObject) {
        this.clientObjectsById.remove(clientObject.getId());
    }

    public ClientObject getClientObject(String clientObjectId) {
        return this.clientObjectsById.get(clientObjectId);
    }

    public String createResourceLink(Resource resource) {
        return this.createResourceLink(resource, null);
    }

    public void showWindow(Window window, int animationDuration) {
        window.show(animationDuration);
    }

    public void download(Resource resource, String downloadFileName) {
        this.download(this.createResourceLink(resource), downloadFileName);
    }

    public void download(File file, String downloadFileName) {
        this.download(this.createFileLink(file), downloadFileName);
    }

    public void download(String url, String downloadFileName) {
        this.runWithContext(() -> this.queueCommand((UiCommand<?>)new UiRootPanel.DownloadFileCommand(url, downloadFileName)));
    }

    public void registerBackgroundImage(String id, String image, String blurredImage) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.RegisterBackgroundImageCommand(id, image, blurredImage));
    }

    public void setBackgroundImage(String id, int animationDuration) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.SetBackgroundImageCommand(id, animationDuration));
    }

    public void showDefaultBackground(int animationDuration) {
        if (!this.defaultBackgroundRegistered) {
            this.defaultBackgroundRegistered = true;
            this.registerBackgroundImage(DEFAULT_BACKGROUND_NAME, DEFAULT_BACKGROUND_URL, DEFAULT_BACKGROUND_URL);
        }
        this.setBackgroundImage(DEFAULT_BACKGROUND_NAME, animationDuration);
    }

    public void setBackgroundColor(Color color, int animationDuration) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.SetBackgroundColorCommand(color != null ? color.toHtmlColorString() : null, animationDuration));
    }

    public void exitFullScreen() {
        this.queueCommand((UiCommand<?>)new UiRootPanel.ExitFullScreenCommand());
    }

    public void addRootComponent(String containerElementSelector, Component component) {
        this.addRootPanel(containerElementSelector, component);
    }

    public void addRootPanel(String containerElementSelector, Component rootPanel) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.BuildRootPanelCommand(containerElementSelector, rootPanel.createUiReference()));
    }

    public RootPanel addRootPanel(String containerElementSelector) {
        RootPanel rootPanel = new RootPanel();
        this.addRootPanel(containerElementSelector, rootPanel);
        return rootPanel;
    }

    public RootPanel addRootPanel() {
        return this.addRootPanel("body");
    }

    public void addClientToken(String token) {
        this.getClientInfo().getClientTokens().add(token);
        this.queueCommand((UiCommand<?>)new UiRootPanel.AddClientTokenCommand(token));
    }

    public void removeClientToken(String token) {
        this.getClientInfo().getClientTokens().remove(token);
        this.queueCommand((UiCommand<?>)new UiRootPanel.RemoveClientTokenCommand(token));
    }

    public void clearClientTokens() {
        this.getClientInfo().getClientTokens().clear();
        this.queueCommand((UiCommand<?>)new UiRootPanel.ClearClientTokensCommand());
    }

    public void showNotification(Notification notification, NotificationPosition position, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.runWithContext(() -> this.queueCommand((UiCommand<?>)new UiRootPanel.ShowNotificationCommand(notification.createUiReference(), position.toUiNotificationPosition(), entranceAnimation.toUiEntranceAnimation(), exitAnimation.toUiExitAnimation())));
    }

    public void showNotification(Notification notification, NotificationPosition position) {
        this.runWithContext(() -> this.showNotification(notification, position, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT));
    }

    public void showNotification(Icon icon, String caption) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndCaption(icon, caption);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description, boolean dismissable, int displayTimeInMillis, boolean showProgress) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(dismissable);
            notification.setDisplayTimeInMillis(displayTimeInMillis);
            notification.setShowProgressBar(showProgress);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void setSessionExpiredWindow(Window sessionExpiredWindow) {
        this.sessionExpiredWindow = sessionExpiredWindow;
        this.updateSessionMessageWindows();
    }

    public void setSessionErrorWindow(Window sessionErrorWindow) {
        this.sessionErrorWindow = sessionErrorWindow;
        this.updateSessionMessageWindows();
    }

    public void setSessionTerminatedWindow(Window sessionTerminatedWindow) {
        this.sessionTerminatedWindow = sessionTerminatedWindow;
        this.updateSessionMessageWindows();
    }

    private void updateSessionMessageWindows() {
        this.queueCommand((UiCommand<?>)new UiRootPanel.SetSessionMessageWindowsCommand(this.sessionExpiredWindow != null ? this.sessionExpiredWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.sessionExpired", new Object[0]), this.getLocalized("teamapps.common.sessionExpiredText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference(), this.sessionErrorWindow != null ? this.sessionErrorWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.error", new Object[0]), this.getLocalized("teamapps.common.sessionErrorText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference(), this.sessionTerminatedWindow != null ? this.sessionTerminatedWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.sessionTerminated", new Object[0]), this.getLocalized("teamapps.common.sessionTerminatedText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference()));
    }

    public static Window createDefaultSessionMessageWindow(String title, String message, String refreshButtonCaption, String cancelButtonCaption) {
        Window window = new Window(null, title, null, 300, 300, false, false, false);
        window.setPadding(10);
        VerticalLayout verticalLayout = new VerticalLayout();
        DisplayField messageField = new DisplayField(false, false);
        messageField.setCssStyle("font-size", "110%");
        messageField.setValue(message);
        verticalLayout.addComponentFillRemaining(messageField);
        Button<String> refreshButton = new Button<String>(null, refreshButtonCaption);
        refreshButton.setCssStyle("margin", "10px 0");
        refreshButton.setCssStyle(".UiButton", "background-color", RgbaColor.MATERIAL_BLUE_600.toHtmlColorString());
        refreshButton.setCssStyle(".UiButton", "color", RgbaColor.WHITE.toHtmlColorString());
        refreshButton.setCssStyle(".UiButton", "font-size", "120%");
        refreshButton.setCssStyle(".UiButton", "height", "50px");
        refreshButton.setOnClickJavaScript("window.location.reload()");
        verticalLayout.addComponentAutoSize(refreshButton);
        if (cancelButtonCaption != null) {
            LinkButton cancelLink = new LinkButton(cancelButtonCaption);
            cancelLink.setCssStyle("text-align", "center");
            cancelLink.setOnClickJavaScript("context.getClientObjectById(\"" + window.createUiReference().getId() + "\").close();");
            verticalLayout.addComponentAutoSize(cancelLink);
        }
        window.setContent(verticalLayout);
        return window;
    }

    public CompletableFuture<WakeLock> requestWakeLock() {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<WakeLock> completableFuture = new CompletableFuture<WakeLock>();
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.RequestWakeLockCommand(uuid), (Consumer)successful -> {
            if (successful.booleanValue()) {
                completableFuture.complete(() -> this.queueCommand((UiCommand<?>)new UiRootPanel.ReleaseWakeLockCommand(uuid)));
            } else {
                completableFuture.completeExceptionally(new RuntimeException("Could not acquire WakeLock"));
            }
        }));
        return completableFuture;
    }

    public void goToUrl(String url, boolean blankPage) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.GoToUrlCommand(url, blankPage));
    }

    public void setGlobalKeyEventsEnabled(boolean unmodified, boolean modifiedWithAltKey, boolean modifiedWithCtrlKey, boolean modifiedWithMetaKey, boolean includeRepeats, boolean keyDown, boolean keyUp) {
        this.queueCommand((UiCommand<?>)new UiRootPanel.SetGlobalKeyEventsEnabledCommand(unmodified, modifiedWithAltKey, modifiedWithCtrlKey, modifiedWithMetaKey, includeRepeats, keyDown, keyUp));
    }

    public String getSessionId() {
        return this.uiSession.getSessionId();
    }

    public void handleStaticEvent(UiEvent event) {
        UiEventType uiEventType = event.getUiEventType();
        switch (uiEventType) {
            case UI_ROOT_PANEL_GLOBAL_KEY_EVENT_OCCURRED: {
                UiRootPanel.GlobalKeyEventOccurredEvent e = (UiRootPanel.GlobalKeyEventOccurredEvent)event;
                this.onGlobalKeyEventOccurred.fire(new KeyboardEvent(e.getEventType(), e.getSourceComponentId() != null ? (Component)this.getClientObject(e.getSourceComponentId()) : null, e.getCode(), e.getIsComposing(), e.getKey(), e.getCharCode(), e.getKeyCode(), e.getLocale(), e.getLocation(), e.getRepeat(), e.getAltKey(), e.getCtrlKey(), e.getShiftKey(), e.getMetaKey()));
                break;
            }
            case UI_ROOT_PANEL_NAVIGATION_STATE_CHANGE: {
                Location location;
                UiRootPanel.NavigationStateChangeEvent e = (UiRootPanel.NavigationStateChangeEvent)event;
                this.currentLocation = location = Location.fromUiLocation(e.getLocation());
                this.onNavigationStateChange.fire(new NavigationStateChangeEvent(location, e.getTriggeredByUser()));
                break;
            }
            default: {
                throw new TeamAppsUiApiException(this.getSessionId(), uiEventType.toString());
            }
        }
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public UiSessionListener getAsUiSessionListenerInternal() {
        return this.uiSessionListener;
    }

    public void setName(String name) {
        this.uiSession.setName(name);
    }

    public String getName() {
        return this.uiSession.getName();
    }
}

