/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession.statistics.app;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.value.SortDirection;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.uisession.UiSessionState;
import org.teamapps.uisession.statistics.CountStats;
import org.teamapps.uisession.statistics.SumStats;
import org.teamapps.uisession.statistics.UiSessionStats;
import org.teamapps.uisession.statistics.app.SessionStatsSharedBaseTableModel;
import org.teamapps.uisession.statistics.app.SessionStatsTableRecord;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.Label;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.flexcontainer.FlexSizeUnit;
import org.teamapps.ux.component.flexcontainer.FlexSizingPolicy;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.SessionContext;

public class SessionStatsPerspective {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Table<SessionStatsTableRecord> table;
    private final VerticalLayout detailVerticalLayout;
    private final ToolbarButtonGroup detailsToolbarButtonGroup;
    private CountStatsTableModel commandStatsTableModel;
    private CountStatsTableModel eventStatsTableModel;
    private CountStatsTableModel commandResultStatsTableModel;
    private CountStatsTableModel queryStatsTableModel;
    private CountStatsTableModel queryResultStatsTableModel;

    public SessionStatsPerspective(SessionStatsSharedBaseTableModel baseTableModel) {
        this.table = this.createMasterTable(baseTableModel);
        this.detailVerticalLayout = this.createDetailVerticalLayout();
        this.detailsToolbarButtonGroup = this.createDetailsToolbarButtonGroup();
    }

    private Table<SessionStatsTableRecord> createMasterTable(SessionStatsSharedBaseTableModel baseTableModel) {
        Table<SessionStatsTableRecord> table = new Table<SessionStatsTableRecord>();
        table.addColumn("startTime", "Start Time", new InstantDateTimeField()).setValueExtractor(record -> Instant.ofEpochMilli(record.getStatistics().getStartTime()));
        table.addColumn("endTime", "End Time", new InstantDateTimeField()).setValueExtractor(record -> record.getStatistics().getEndTime() > 0L ? Instant.ofEpochMilli(record.getStatistics().getEndTime()) : null);
        table.addColumn("sessionId", "ID", new TextField()).setDefaultWidth(50).setValueExtractor(record -> record.getStatistics().getSessionId().toString());
        table.addColumn("name", "Name", new TextField()).setValueExtractor(record -> record.getStatistics().getName());
        table.addColumn("state", "State", new TemplateField(BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE)).setDefaultWidth(120).setValueExtractor(record -> {
            UiSessionState state = record.getStatistics().getState();
            Object icon = state == UiSessionState.ACTIVE ? MaterialIcon.CHECK : (state == UiSessionState.NEARLY_INACTIVE ? CompositeIcon.of((Icon)MaterialIcon.CHECK, (Icon)MaterialIcon.SCHEDULE) : (state == UiSessionState.INACTIVE ? MaterialIcon.SCHEDULE : (state == UiSessionState.CLOSED ? MaterialIcon.CANCEL : MaterialIcon.HELP_OUTLINE)));
            return new BaseTemplateRecord((Icon)icon, state.name());
        });
        table.addColumn("bufferSize", "Cmd Buf Size", new NumberField(0)).setDefaultWidth(90).setValueExtractor(record -> record.getClientBackPressureInfo() != null ? Integer.valueOf(record.getClientBackPressureInfo().getUnconsumedCommandsCount()) : null);
        table.addColumn("readyToReceive", "Ready To Receive", new CheckBox()).setDefaultWidth(40).setValueExtractor(record -> record.getClientBackPressureInfo() != null && record.getClientBackPressureInfo().getRemainingRequestedCommands() > 0);
        this.addSumStatsColumns(table, "sentData", "Data Sent", record -> record.getStatistics().getSentDataStats());
        this.addSumStatsColumns(table, "receivedData", "Data Recvd.", record -> record.getStatistics().getReceivedDataStats());
        this.addCountStatsColumns(table, "command", "Commands", record -> record.getStatistics().getCommandStats());
        this.addCountStatsColumns(table, "commandResult", "CmdResults", record -> record.getStatistics().getCommandResultStats());
        this.addCountStatsColumns(table, "event", "Events", record -> record.getStatistics().getEventStats());
        this.addCountStatsColumns(table, "query", "Queries", record -> record.getStatistics().getQueryStats());
        this.addCountStatsColumns(table, "queryResult", "QuResults", record -> record.getStatistics().getQueryResultStats());
        table.setModel(new StatsTableModel(baseTableModel));
        table.onSingleRowSelected.addListener(record -> {
            this.commandStatsTableModel.setStats(record.getStatistics());
            this.eventStatsTableModel.setStats(record.getStatistics());
            this.commandResultStatsTableModel.setStats(record.getStatistics());
            this.queryStatsTableModel.setStats(record.getStatistics());
            this.queryResultStatsTableModel.setStats(record.getStatistics());
        });
        return table;
    }

    private void addCountStatsColumns(Table<SessionStatsTableRecord> table, String propertyNamePrefix, String displayNameInfix, Function<SessionStatsTableRecord, CountStats> countStatsExtractor) {
        table.addColumn(propertyNamePrefix + "Total", displayNameInfix, new NumberField(0)).setDefaultWidth(110).setValueExtractor(record -> ((CountStats)countStatsExtractor.apply((SessionStatsTableRecord)record)).getCount());
        table.addColumn(propertyNamePrefix + "LastMinute", displayNameInfix + " (1m)", new NumberField(0)).setDefaultWidth(110).setValueExtractor(record -> ((CountStats)countStatsExtractor.apply((SessionStatsTableRecord)record)).getCountLastMinute());
    }

    private void addSumStatsColumns(Table<SessionStatsTableRecord> table, String propertyNamePrefix, String displayNameInfix, Function<SessionStatsTableRecord, SumStats> sumStatsExtractor) {
        table.addColumn(propertyNamePrefix + "Total", displayNameInfix, new NumberField(0)).setDefaultWidth(110).setValueExtractor(record -> ((SumStats)sumStatsExtractor.apply((SessionStatsTableRecord)record)).getSum());
        table.addColumn(propertyNamePrefix + "LastMinute", displayNameInfix + " (1m)", new NumberField(0)).setDefaultWidth(110).setValueExtractor(record -> ((SumStats)sumStatsExtractor.apply((SessionStatsTableRecord)record)).getSumLastMinute());
    }

    public Table<SessionStatsTableRecord> getTable() {
        return this.table;
    }

    private VerticalLayout createDetailVerticalLayout() {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setCssStyle("overflow", "auto");
        verticalLayout.addComponent(new Label("Commands"));
        this.commandStatsTableModel = new CountStatsTableModel(UiSessionStats::getCommandStats);
        verticalLayout.addComponent(this.createCountStatsTable(this.commandStatsTableModel), new FlexSizingPolicy(300.0f, FlexSizeUnit.PIXEL, 0, 0));
        verticalLayout.addComponent(new Label("Events"));
        this.eventStatsTableModel = new CountStatsTableModel(UiSessionStats::getEventStats);
        verticalLayout.addComponent(this.createCountStatsTable(this.eventStatsTableModel), new FlexSizingPolicy(300.0f, FlexSizeUnit.PIXEL, 0, 0));
        verticalLayout.addComponent(new Label("CommandResults"));
        this.commandResultStatsTableModel = new CountStatsTableModel(UiSessionStats::getCommandResultStats);
        verticalLayout.addComponent(this.createCountStatsTable(this.commandResultStatsTableModel), new FlexSizingPolicy(300.0f, FlexSizeUnit.PIXEL, 0, 0));
        verticalLayout.addComponent(new Label("Queries"));
        this.queryStatsTableModel = new CountStatsTableModel(UiSessionStats::getQueryStats);
        verticalLayout.addComponent(this.createCountStatsTable(this.queryStatsTableModel), new FlexSizingPolicy(300.0f, FlexSizeUnit.PIXEL, 0, 0));
        verticalLayout.addComponent(new Label("QueryResults"));
        this.queryResultStatsTableModel = new CountStatsTableModel(UiSessionStats::getQueryResultStats);
        verticalLayout.addComponent(this.createCountStatsTable(this.queryResultStatsTableModel), new FlexSizingPolicy(300.0f, FlexSizeUnit.PIXEL, 0, 0));
        return verticalLayout;
    }

    public Component getDetailVerticalLayout() {
        return this.detailVerticalLayout;
    }

    private ToolbarButtonGroup createDetailsToolbarButtonGroup() {
        ToolbarButtonGroup toolbarButtonGroup = new ToolbarButtonGroup();
        toolbarButtonGroup.addButton((ToolbarButton)ToolbarButton.createSmall((Icon)MaterialIcon.REFRESH, (String)"Refresh")).onClick.addListener(() -> {
            this.commandStatsTableModel.refresh();
            this.eventStatsTableModel.refresh();
            this.commandResultStatsTableModel.refresh();
            this.queryStatsTableModel.refresh();
            this.queryResultStatsTableModel.refresh();
        });
        return toolbarButtonGroup;
    }

    public ToolbarButtonGroup getDetailsToolbarButtonGroup() {
        return this.detailsToolbarButtonGroup;
    }

    private Table<CountStatEntry> createCountStatsTable(CountStatsTableModel model) {
        Table<CountStatEntry> table = new Table<CountStatEntry>();
        table.addColumn("className", null, "Class", new TextField(), 400).setValueExtractor(entry -> entry.clazz.getName());
        table.addColumn("count", null, "Count", new NumberField(0), 80).setMinWidth(80).setMaxWidth(120).setValueExtractor(entry -> entry.count);
        table.setForceFitWidth(true);
        table.setModel(model);
        return table;
    }

    private class CountStatsTableModel
    extends AbstractTableModel<CountStatEntry> {
        private final Function<UiSessionStats, CountStats> countStatExtractor;
        private UiSessionStats stats;

        private CountStatsTableModel(Function<UiSessionStats, CountStats> countStatExtractor) {
            this.countStatExtractor = countStatExtractor;
        }

        public void setStats(UiSessionStats stats) {
            this.stats = stats;
            this.onAllDataChanged.fire();
        }

        @Override
        public int getCount() {
            if (this.stats == null) {
                return 0;
            }
            return this.countStatExtractor.apply(this.stats).getCountByClass().size();
        }

        @Override
        public List<CountStatEntry> getRecords(int startIndex, int length) {
            if (this.stats == null) {
                return List.of();
            }
            Comparator<CountStatEntry> comparator = (o1, o2) -> 0;
            if (this.sorting != null) {
                Comparator<CountStatEntry> comparator2 = comparator = Objects.equals(this.sorting.getFieldName(), "className") ? Comparator.comparing(e -> e.clazz.getName()) : Comparator.comparing(e -> e.count);
                if (this.sorting.getSortDirection() == SortDirection.DESC || this.sorting.getFieldName() == null) {
                    comparator = comparator.reversed();
                }
            }
            return this.countStatExtractor.apply(this.stats).getCountByClass().object2LongEntrySet().stream().map(e -> new CountStatEntry((Class)e.getKey(), e.getLongValue())).sorted(comparator).skip(startIndex).limit(length).collect(Collectors.toList());
        }

        public void refresh() {
            this.onAllDataChanged.fire();
        }
    }

    private static class StatsTableModel
    extends AbstractTableModel<SessionStatsTableRecord> {
        private final SessionStatsSharedBaseTableModel baseTableModel;

        public StatsTableModel(SessionStatsSharedBaseTableModel baseTableModel) {
            this.baseTableModel = baseTableModel;
            baseTableModel.onUpdated.addListener(() -> {
                if (SessionContext.current().getClientBackPressureInfo().getUnconsumedCommandsCount() < 100) {
                    this.onAllDataChanged.fire();
                } else {
                    LOGGER.info("Not sending updates due to high amount of unconsumed commands!");
                }
            });
        }

        @Override
        public int getCount() {
            return this.baseTableModel.getRecords().size();
        }

        @Override
        public List<SessionStatsTableRecord> getRecords(int startIndex, int length) {
            Comparator<SessionStatsTableRecord> comparator = (o1, o2) -> 0;
            if (this.sorting != null) {
                switch (this.sorting.getFieldName()) {
                    case "startTime": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getStartTime());
                        break;
                    }
                    case "endTime": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getEndTime());
                        break;
                    }
                    case "sessionId": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getSessionId().toString());
                        break;
                    }
                    case "name": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getName());
                        break;
                    }
                    case "state": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getState());
                        break;
                    }
                    case "bufferSize": {
                        comparator = Comparator.comparing(record -> record.getClientBackPressureInfo() != null ? record.getClientBackPressureInfo().getUnconsumedCommandsCount() : -1);
                        break;
                    }
                    case "readyToReceive": {
                        comparator = Comparator.comparing(record -> record.getClientBackPressureInfo() != null && record.getClientBackPressureInfo().getRemainingRequestedCommands() > 0);
                        break;
                    }
                    case "sentDataTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getSentDataStats().getSum());
                        break;
                    }
                    case "sentDataLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getSentDataStats().getSumLastMinute());
                        break;
                    }
                    case "receivedDataTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getReceivedDataStats().getSum());
                        break;
                    }
                    case "receivedDataLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getReceivedDataStats().getSumLastMinute());
                        break;
                    }
                    case "commandTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getCommandStats().getCount());
                        break;
                    }
                    case "commandLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getCommandStats().getCountLastMinute());
                        break;
                    }
                    case "commandResultTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getCommandResultStats().getCount());
                        break;
                    }
                    case "commandResultLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getCommandResultStats().getCountLastMinute());
                        break;
                    }
                    case "eventTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getEventStats().getCount());
                        break;
                    }
                    case "eventLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getEventStats().getCountLastMinute());
                        break;
                    }
                    case "queryTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getQueryStats().getCount());
                        break;
                    }
                    case "queryLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getQueryStats().getCountLastMinute());
                        break;
                    }
                    case "queryResultTotal": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getQueryResultStats().getCount());
                        break;
                    }
                    case "queryResultLastMinute": {
                        comparator = Comparator.comparing(record -> record.getStatistics().getQueryResultStats().getCountLastMinute());
                    }
                }
                if (this.sorting.getSortDirection() == SortDirection.DESC) {
                    comparator = comparator.reversed();
                }
            }
            return this.baseTableModel.getRecords().stream().sorted(comparator).skip(startIndex).limit(length).collect(Collectors.toList());
        }
    }

    private static class CountStatEntry {
        private final Class<?> clazz;
        private final long count;

        public CountStatEntry(Class<?> clazz, long count) {
            this.clazz = clazz;
            this.count = count;
        }
    }
}

