/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.format;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiFontStyle;

public class FontStyle {
    protected float relativeFontSize = 1.0f;
    protected Color fontColor;
    protected Color backgroundColor;
    protected boolean bold;
    protected boolean underline;
    protected boolean italic;

    public FontStyle() {
    }

    public FontStyle(float relativeFontSize) {
        this.relativeFontSize = relativeFontSize;
    }

    public FontStyle(float relativeFontSize, Color fontColor) {
        this.relativeFontSize = relativeFontSize;
        this.fontColor = fontColor;
    }

    public FontStyle(float relativeFontSize, Color fontColor, Color backgroundColor, boolean bold, boolean underline, boolean italic) {
        this.relativeFontSize = relativeFontSize;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
        this.bold = bold;
        this.underline = underline;
        this.italic = italic;
    }

    public FontStyle setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public FontStyle setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public FontStyle setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public FontStyle setUnderline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public FontStyle setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public FontStyle setRelativeFontSize(float relativeFontSize) {
        this.relativeFontSize = relativeFontSize;
        return this;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public float getRelativeFontSize() {
        return this.relativeFontSize;
    }

    public UiFontStyle createUiFontStyle() {
        UiFontStyle uiFontStyle = new UiFontStyle();
        uiFontStyle.setFontColor(this.fontColor != null ? this.fontColor.toHtmlColorString() : null);
        uiFontStyle.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        uiFontStyle.setBold(this.bold);
        uiFontStyle.setUnderline(this.underline);
        uiFontStyle.setItalic(this.italic);
        uiFontStyle.setRelativeFontSize(this.relativeFontSize);
        return uiFontStyle;
    }
}

