/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.teamapps.ux.component.media.MediaTrackData;

public class AudioGraph {
    private final byte[] outerMax;
    private final byte[] outerMin;
    private final byte[] innerMax;
    private final byte[] innerMin;
    private final int resolution;
    private final int duration;

    public AudioGraph(int resolution, int duration) {
        this.resolution = resolution;
        this.duration = duration;
        this.outerMax = new byte[resolution];
        this.outerMin = new byte[resolution];
        this.innerMax = new byte[resolution];
        this.innerMin = new byte[resolution];
    }

    public AudioGraph(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.duration = dis.readInt();
        this.resolution = dis.readInt();
        this.outerMax = new byte[this.resolution];
        this.outerMin = new byte[this.resolution];
        this.innerMax = new byte[this.resolution];
        this.innerMin = new byte[this.resolution];
        for (int i = 0; i < this.resolution; ++i) {
            this.outerMax[i] = dis.readByte();
            this.outerMin[i] = dis.readByte();
            this.innerMax[i] = dis.readByte();
            this.innerMin[i] = dis.readByte();
        }
    }

    public byte[] save() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.duration);
        dos.writeInt(this.resolution);
        for (int i = 0; i < this.resolution; ++i) {
            dos.writeByte(this.outerMax[i]);
            dos.writeByte(this.outerMin[i]);
            dos.writeByte(this.innerMax[i]);
            dos.writeByte(this.innerMin[i]);
        }
        return bos.toByteArray();
    }

    private byte[] readArray(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = dis.readByte();
        }
        return bytes;
    }

    public MediaTrackData createTrackData() {
        MediaTrackData data = new MediaTrackData();
        data.setTrackCount(1);
        double timeFactor = (double)this.duration * 1.0 / (double)this.resolution;
        for (int i = 0; i < this.resolution; ++i) {
            data.addData((long)((double)i * timeFactor), this.getGraphData(i));
        }
        return data;
    }

    private int[] getGraphData(int pos) {
        int[] value = new int[]{this.getConvertedValue(pos, this.outerMax), this.getConvertedValue(pos, this.outerMin), this.getConvertedValue(pos, this.innerMax), this.getConvertedValue(pos, this.innerMin)};
        return value;
    }

    private int getConvertedValue(int pos, byte[] data) {
        byte value = data[pos];
        return (int)((float)value / 1.28f);
    }

    public byte[] getOuterMax() {
        return this.outerMax;
    }

    public byte[] getOuterMin() {
        return this.outerMin;
    }

    public byte[] getInnerMax() {
        return this.innerMax;
    }

    public byte[] getInnerMin() {
        return this.innerMin;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getDuration() {
        return this.duration;
    }

    public static AudioGraph createGraph(File pcmFile) throws IOException {
        return AudioGraph.createGraph(pcmFile, 400, (int)(pcmFile.length() / 16L), 8000);
    }

    public static AudioGraph createGraph(File pcmFile, int resolution) throws IOException {
        return AudioGraph.createGraph(pcmFile, resolution, (int)(pcmFile.length() / 16L), 8000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioGraph createGraph(File pcmFile, int resolution, int durationMs, int sampleRate) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(pcmFile));
            AudioGraph audioGraph = AudioGraph.createGraph(in, resolution, durationMs, sampleRate);
            return audioGraph;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static AudioGraph createGraph(InputStream pcmIn, int resolution, int durationMs, int sampleRate) throws IOException {
        AudioGraph graph = new AudioGraph(resolution, durationMs);
        DataInputStream in = new DataInputStream(new BufferedInputStream(pcmIn));
        int samplesPerPoint = (int)((long)durationMs * (long)sampleRate / 1000L / (long)resolution);
        int msPerPoint = durationMs / resolution;
        if (samplesPerPoint == 0 || msPerPoint == 0) {
            return graph;
        }
        byte[] buf = new byte[4 * samplesPerPoint];
        ByteBuffer sampleBuf = ByteBuffer.wrap(buf);
        sampleBuf.order(ByteOrder.LITTLE_ENDIAN);
        for (int pos = 0; pos < resolution; ++pos) {
            int bytes;
            int read;
            Arrays.fill(buf, (byte)0);
            int samples = (int)((long)durationMs * (long)(pos + 1) * (long)sampleRate / 1000L / (long)resolution - (long)durationMs * (long)pos * (long)sampleRate / 1000L / (long)resolution);
            if (samples == 0 || (read = in.read(buf, 0, bytes = samples * 2)) < 0) break;
            if (read < bytes) {
                System.err.println("read " + read + " of " + bytes);
            }
            long sum = 0L;
            short max = Short.MIN_VALUE;
            short min = Short.MAX_VALUE;
            sampleBuf.position(0);
            for (int j = 0; j < samples; ++j) {
                short val = sampleBuf.getShort();
                if (val > max) {
                    max = val;
                }
                if (val < min) {
                    min = val;
                }
                sum += (long)val;
            }
            short avg = (short)(sum / (long)samples);
            long squares = 0L;
            sampleBuf.position(0);
            for (int j = 0; j < samples; ++j) {
                int deviation = sampleBuf.getShort() - avg;
                squares += (long)(deviation * deviation);
            }
            short rms = (short)Math.sqrt(squares / (long)samples);
            graph.outerMax[pos] = AudioGraph.toByte(max);
            graph.outerMin[pos] = AudioGraph.toByte(min);
            graph.innerMax[pos] = AudioGraph.toByte((short)(avg + rms));
            graph.innerMin[pos] = AudioGraph.toByte((short)(avg - rms));
        }
        return graph;
    }

    private static byte toByte(short max) {
        byte b = (byte)(max / 256);
        if (b == -128) {
            b = (byte)(b + 1);
        }
        return b;
    }
}

