/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiField;
import org.teamapps.dto.UiMultiLineTextField;
import org.teamapps.ux.component.field.MultiWriteLockableValue;
import org.teamapps.ux.component.field.TextField;

public class MultiLineTextField
extends TextField {
    private boolean adjustHeightToContent = false;

    @Override
    public UiField createUiComponent() {
        UiMultiLineTextField uiField = new UiMultiLineTextField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setMaxCharacters(this.getMaxCharacters());
        uiField.setShowClearButton(this.isShowClearButton());
        uiField.setPlaceholderText(this.getEmptyText());
        uiField.setAdjustHeightToContent(this.adjustHeightToContent);
        return uiField;
    }

    public void append(String s, boolean scrollToBottom) {
        MultiWriteLockableValue.Lock lock = this.setAndLockValue(s);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiMultiLineTextField.AppendCommand(this.getId(), s, scrollToBottom), aVoid -> lock.release());
        } else {
            lock.release();
        }
    }

    public boolean isAdjustHeightToContent() {
        return this.adjustHeightToContent;
    }

    public void setAdjustHeightToContent(boolean adjustHeightToContent) {
        this.adjustHeightToContent = adjustHeightToContent;
    }
}

