/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.splitpane;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiSplitPane;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.splitpane.SplitDirection;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;

public class SplitPane
extends AbstractComponent {
    public Event<Float> onResized = new Event();
    private SplitDirection splitDirection;
    private SplitSizePolicy sizePolicy;
    private float referenceChildSize;
    private Component firstChild;
    private Component lastChild;
    private int firstChildMinSize = 10;
    private int lastChildMinSize = 10;
    private boolean resizable = true;
    private boolean fillIfSingleChild = true;
    private boolean collapseEmptyChildren = true;

    public static SplitPane createHorizontalSplitPane() {
        return new SplitPane(SplitDirection.HORIZONTAL);
    }

    public static SplitPane createVerticalSplitPane() {
        return new SplitPane(SplitDirection.VERTICAL);
    }

    public SplitPane(SplitDirection splitDirection) {
        this(splitDirection, SplitSizePolicy.RELATIVE, 0.5f);
    }

    public SplitPane(SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize) {
        this.splitDirection = splitDirection;
        this.sizePolicy = sizePolicy;
        this.referenceChildSize = referenceChildSize;
    }

    @Override
    public UiComponent createUiComponent() {
        UiSplitPane uiSplitPane = new UiSplitPane(this.splitDirection.toUiSplitDirection(), this.sizePolicy.toUiSplitSizePolicy());
        this.mapAbstractUiComponentProperties((UiComponent)uiSplitPane);
        uiSplitPane.setReferenceChildSize(this.referenceChildSize);
        if (this.firstChild != null) {
            uiSplitPane.setFirstChild(this.firstChild.createUiReference());
        }
        if (this.lastChild != null) {
            uiSplitPane.setLastChild(this.lastChild.createUiReference());
        }
        uiSplitPane.setFirstChildMinSize(this.firstChildMinSize);
        uiSplitPane.setLastChildMinSize(this.lastChildMinSize);
        uiSplitPane.setResizable(this.resizable);
        uiSplitPane.setFillIfSingleChild(this.fillIfSingleChild);
        uiSplitPane.setCollapseEmptyChildren(this.collapseEmptyChildren);
        return uiSplitPane;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_SPLIT_PANE_SPLIT_RESIZED: {
                UiSplitPane.SplitResizedEvent resizedEvent = (UiSplitPane.SplitResizedEvent)event;
                this.referenceChildSize = resizedEvent.getReferenceChildSize();
                this.onResized.fire(Float.valueOf(resizedEvent.getReferenceChildSize()));
            }
        }
    }

    public Component getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(Component firstChild) {
        this.firstChild = firstChild;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetFirstChildCommand(this.getId(), firstChild != null ? firstChild.createUiReference() : null));
    }

    public Component getLastChild() {
        return this.lastChild;
    }

    public void setLastChild(Component lastChild) {
        this.lastChild = lastChild;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetLastChildCommand(this.getId(), lastChild != null ? lastChild.createUiReference() : null));
    }

    public void setSize(float referenceChildSize, SplitSizePolicy sizePolicy) {
        if (sizePolicy == null) {
            return;
        }
        this.referenceChildSize = referenceChildSize;
        this.sizePolicy = sizePolicy;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetSizeCommand(this.getId(), referenceChildSize, sizePolicy.toUiSplitSizePolicy()));
    }

    public SplitDirection getSplitDirection() {
        return this.splitDirection;
    }

    public void setSplitDirection(SplitDirection splitDirection) {
        boolean changed = splitDirection != this.splitDirection;
        this.splitDirection = splitDirection;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public SplitSizePolicy getSizePolicy() {
        return this.sizePolicy;
    }

    public void setSizePolicy(SplitSizePolicy sizePolicy) {
        this.sizePolicy = sizePolicy;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetSizeCommand(this.getId(), this.referenceChildSize, sizePolicy.toUiSplitSizePolicy()));
    }

    public float getReferenceChildSize() {
        return this.referenceChildSize;
    }

    public void setReferenceChildSize(float referenceChildSize) {
        this.referenceChildSize = referenceChildSize;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetSizeCommand(this.getId(), referenceChildSize, this.sizePolicy.toUiSplitSizePolicy()));
    }

    public int getFirstChildMinSize() {
        return this.firstChildMinSize;
    }

    public void setFirstChildMinSize(int firstChildMinSize) {
        this.firstChildMinSize = firstChildMinSize;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetFirstChildMinSizeCommand(this.getId(), firstChildMinSize));
    }

    public int getLastChildMinSize() {
        return this.lastChildMinSize;
    }

    public void setLastChildMinSize(int lastChildMinSize) {
        this.lastChildMinSize = lastChildMinSize;
        this.queueCommandIfRendered(() -> new UiSplitPane.SetLastChildMinSizeCommand(this.getId(), lastChildMinSize));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.reRenderIfRendered();
    }

    public boolean isFillIfSingleChild() {
        return this.fillIfSingleChild;
    }

    public void setFillIfSingleChild(boolean fillIfSingleChild) {
        this.fillIfSingleChild = fillIfSingleChild;
        this.reRenderIfRendered();
    }

    public boolean isCollapseEmptyChildren() {
        return this.collapseEmptyChildren;
    }

    public void setCollapseEmptyChildren(boolean collapseEmptyChildren) {
        this.collapseEmptyChildren = collapseEmptyChildren;
        this.reRenderIfRendered();
    }
}

