/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.teamapps.ux.component.node.TreeNode;

public class EagerNodesFilter
implements Predicate<TreeNode> {
    private final TreeNode evaluationRootNode;
    private final Map<TreeNode, Boolean> includedInResultByNode = new HashMap<TreeNode, Boolean>();

    public EagerNodesFilter() {
        this.evaluationRootNode = null;
    }

    public EagerNodesFilter(TreeNode evaluationRootNode) {
        this.evaluationRootNode = evaluationRootNode;
    }

    @Override
    public boolean test(TreeNode node) {
        if (this.includedInResultByNode.containsKey(node)) {
            return this.includedInResultByNode.get(node);
        }
        if (node.getParent() == null || node.getParent() == this.evaluationRootNode) {
            this.includedInResultByNode.put(node, true);
            return true;
        }
        if (node.getParent().isLazyChildren() && !node.getParent().isExpanded()) {
            this.includedInResultByNode.put(node, false);
            return false;
        }
        boolean parentIncluded = this.test(node.getParent());
        this.includedInResultByNode.put(node, parentIncluded);
        return parentIncluded;
    }
}

