/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.RecordsAddedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsChangedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsRemovedEvent;

public class ListInfiniteItemViewModel<RECORD>
extends AbstractInfiniteItemViewModel<RECORD> {
    private List<RECORD> records;

    public ListInfiniteItemViewModel() {
        this.records = new ArrayList<RECORD>();
    }

    public ListInfiniteItemViewModel(List<RECORD> records) {
        this.records = records;
    }

    public void addRecord(RECORD record) {
        this.addRecord(this.records.size(), record);
    }

    public void addRecord(int index, RECORD record) {
        this.records.add(index, record);
        this.onRecordsAdded.fire(new RecordsAddedEvent<RECORD>(index, Collections.singletonList(record)));
    }

    public void addRecords(List<RECORD> records) {
        this.addRecords(records.size(), records);
    }

    public void addRecords(int index, List<RECORD> records) {
        this.records.addAll(index, records);
        this.onRecordsAdded.fire(new RecordsAddedEvent<RECORD>(index, records));
    }

    public void removeRecord(RECORD record) {
        this.removeRecord(this.records.indexOf(record));
    }

    public void removeRecord(int index) {
        this.onRecordsDeleted.fire(new RecordsRemovedEvent(ItemRange.startLength(index, 1)));
    }

    public void removeRecord(int startIndex, int length) {
        List<RECORD> subList = this.records.subList(startIndex, startIndex + length);
        subList.clear();
        this.onRecordsDeleted.fire(new RecordsRemovedEvent(ItemRange.startLength(startIndex, length)));
    }

    public void updateRecord(int index) {
        this.onRecordsChanged.fire(new RecordsChangedEvent<RECORD>(index, List.of(this.records.get(index))));
    }

    public void updateRecords(int startIndex, int length) {
        this.onRecordsChanged.fire(new RecordsChangedEvent(ItemRange.startLength(startIndex, length)));
    }

    public void replaceRecord(int index, RECORD record) {
        this.records.set(index, record);
        this.onRecordsChanged.fire(new RecordsChangedEvent<RECORD>(index, Collections.singletonList(record)));
    }

    public void replaceRecords(int startIndex, List<RECORD> records) {
        for (int i = 0; i < records.size(); ++i) {
            records.set(startIndex + i, records.get(i));
        }
        this.onRecordsChanged.fire(new RecordsChangedEvent(ItemRange.startLength(startIndex, records.size())));
    }

    public void setRecords(List<RECORD> records) {
        this.records = records;
        this.onAllDataChanged.fire(null);
    }

    @Override
    public int getCount() {
        return this.records.size();
    }

    @Override
    public List<RECORD> getRecords(int startIndex, int length) {
        return this.records.stream().skip(startIndex).limit(length).collect(Collectors.toList());
    }
}

