/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.panel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.ObservableValue;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiPanel;
import org.teamapps.dto.UiPanelHeaderField;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.panel.HeaderComponentMinimizationPolicy;
import org.teamapps.ux.component.panel.WindowButtonType;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbutton.ToolButton;

public class Panel
extends AbstractComponent
implements Component {
    public final Event<WindowButtonType> onWindowButtonClicked = new Event();
    private String title;
    private Icon icon;
    private AbstractField<?> leftHeaderField;
    private Icon leftHeaderFieldIcon;
    private int leftHeaderFieldMinWidth = 100;
    private int leftHeaderFieldMaxWidth = 300;
    private AbstractField<?> rightHeaderField;
    private Icon rightHeaderFieldIcon;
    private int rightHeaderFieldMinWidth = 100;
    private int rightHeaderFieldMaxWidth = 300;
    private HeaderComponentMinimizationPolicy headerComponentMinimizationPolicy = HeaderComponentMinimizationPolicy.LEFT_COMPONENT_FIRST;
    private boolean alwaysShowHeaderFieldIcons = false;
    private Component content;
    private boolean stretchContent = true;
    private boolean hideTitleBar;
    private Toolbar toolbar;
    private int padding = 0;
    private final List<ToolButton> toolButtons = new ArrayList<ToolButton>();
    private final Set<WindowButtonType> windowButtons = new HashSet<WindowButtonType>();
    private ObservableValue<Icon> observableIcon;
    private final Consumer<Icon> iconChangeListener = this::setIcon;
    private ObservableValue<String> observableTitle;
    private final Consumer<String> titleChangeListener = this::setTitle;
    private ObservableValue<AbstractField<?>> observableLeftHeaderField;
    private final Consumer<AbstractField<?>> leftHeaderFieldChangeListener = this::setLeftHeaderField;
    private ObservableValue<AbstractField<?>> observableRightHeaderField;
    private final Consumer<AbstractField<?>> rightHeaderFieldChangeListener = this::setRightHeaderField;

    public Panel() {
        this(null, null, null);
    }

    public Panel(Icon icon, String title) {
        this(icon, title, null);
    }

    public Panel(Icon icon, String title, Component content) {
        this.icon = icon;
        this.title = title;
        this.setContent(content);
    }

    public void addToolButton(ToolButton toolButton) {
        this.toolButtons.add(toolButton);
        toolButton.setParent(this);
        this.updateToolButtons();
    }

    public void removeToolButton(ToolButton toolButton) {
        this.toolButtons.remove(toolButton);
        toolButton.setParent(null);
        this.updateToolButtons();
    }

    public void setToolButtons(List<ToolButton> toolButtons) {
        this.toolButtons.clear();
        if (toolButtons != null) {
            this.toolButtons.addAll(toolButtons);
            this.toolButtons.forEach(toolButton -> toolButton.setParent(this));
        }
        this.updateToolButtons();
    }

    private void updateToolButtons() {
        this.queueCommandIfRendered(() -> new UiPanel.SetToolButtonsCommand(this.getId(), this.toolButtons.stream().map(toolButton -> toolButton.createUiReference()).collect(Collectors.toList())));
    }

    public List<ToolButton> getToolButtons() {
        return this.toolButtons;
    }

    public void setWindowButtons(Collection<WindowButtonType> buttons) {
        this.windowButtons.clear();
        this.windowButtons.addAll(buttons);
        this.updateWindowButtons();
    }

    private void updateWindowButtons() {
        this.queueCommandIfRendered(() -> new UiPanel.SetWindowButtonsCommand(this.getId(), this.windowButtons.stream().map(b -> b.toUiWindowButtonType()).collect(Collectors.toList())));
    }

    public Set<WindowButtonType> getWindowButtons() {
        return Collections.unmodifiableSet(this.windowButtons);
    }

    @Override
    public UiComponent createUiComponent() {
        UiPanel uiPanel = new UiPanel();
        this.mapUiPanelProperties(uiPanel);
        return uiPanel;
    }

    protected void mapUiPanelProperties(UiPanel uiPanel) {
        this.mapAbstractUiComponentProperties((UiComponent)uiPanel);
        uiPanel.setTitle(this.title);
        uiPanel.setIcon(this.getSessionContext().resolveIcon(this.icon));
        uiPanel.setLeftHeaderField(this.createUiPanelHeaderField(this.leftHeaderField, this.leftHeaderFieldIcon, this.leftHeaderFieldMinWidth, this.leftHeaderFieldMaxWidth));
        uiPanel.setRightHeaderField(this.createUiPanelHeaderField(this.rightHeaderField, this.rightHeaderFieldIcon, this.rightHeaderFieldMinWidth, this.rightHeaderFieldMaxWidth));
        uiPanel.setHeaderComponentMinimizationPolicy(this.headerComponentMinimizationPolicy.toUiHeaderComponentMinimizationPolicy());
        uiPanel.setHideTitleBar(this.hideTitleBar);
        uiPanel.setToolbar(Component.createUiClientObjectReference(this.toolbar));
        uiPanel.setContent(this.content != null ? this.content.createUiReference() : null);
        uiPanel.setPadding(this.padding);
        uiPanel.setWindowButtons(this.windowButtons.stream().map(b -> b.toUiWindowButtonType()).collect(Collectors.toList()));
        uiPanel.setToolButtons(this.toolButtons.stream().map(toolButton -> toolButton.createUiReference()).collect(Collectors.toList()));
        uiPanel.setAlwaysShowHeaderFieldIcons(this.alwaysShowHeaderFieldIcons);
        uiPanel.setStretchContent(this.stretchContent);
    }

    public UiPanelHeaderField createUiPanelHeaderField(AbstractField<?> field, Icon icon, int minWidth, int maxWidth) {
        if (field == null) {
            return null;
        }
        UiPanelHeaderField uiPanelHeaderField = new UiPanelHeaderField(field.createUiReference());
        uiPanelHeaderField.setIcon(this.getSessionContext().resolveIcon(icon));
        uiPanelHeaderField.setMinWidth(minWidth);
        uiPanelHeaderField.setMaxWidth(maxWidth);
        return uiPanelHeaderField;
    }

    public Panel setLeftHeaderField(AbstractField<?> field, Icon icon, int minWidth, int maxWidth) {
        if (field != null) {
            field.setParent(this);
        }
        this.leftHeaderField = field;
        this.leftHeaderFieldIcon = icon;
        this.leftHeaderFieldMinWidth = minWidth;
        this.leftHeaderFieldMaxWidth = maxWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetLeftHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.leftHeaderField, this.leftHeaderFieldIcon, this.leftHeaderFieldMinWidth, this.leftHeaderFieldMaxWidth)));
        return this;
    }

    public AbstractField<?> getLeftHeaderField() {
        return this.leftHeaderField;
    }

    public Panel setRightHeaderField(AbstractField<?> field, Icon icon, int minWidth, int maxWidth) {
        if (field != null) {
            field.setParent(this);
        }
        this.rightHeaderField = field;
        this.rightHeaderFieldIcon = icon;
        this.rightHeaderFieldMinWidth = minWidth;
        this.rightHeaderFieldMaxWidth = maxWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetRightHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.rightHeaderField, this.rightHeaderFieldIcon, this.rightHeaderFieldMinWidth, this.rightHeaderFieldMaxWidth)));
        return this;
    }

    public AbstractField<?> getRightHeaderField() {
        return this.rightHeaderField;
    }

    public void setContent(Component content) {
        this.content = content;
        if (content != null) {
            content.setParent(this);
        }
        this.queueCommandIfRendered(() -> new UiPanel.SetContentCommand(this.getId(), content != null ? content.createUiReference() : null));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_PANEL_WINDOW_BUTTON_CLICKED: {
                UiPanel.WindowButtonClickedEvent clickedEvent = (UiPanel.WindowButtonClickedEvent)event;
                this.onWindowButtonClicked.fire(WindowButtonType.fromUiWindowButtonType(clickedEvent.getWindowButton()));
                break;
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.queueCommandIfRendered(() -> new UiPanel.SetTitleCommand(this.getId(), title));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.queueCommandIfRendered(() -> new UiPanel.SetIconCommand(this.getId(), this.getSessionContext().resolveIcon(icon)));
    }

    public Component getContent() {
        return this.content;
    }

    public void setHeaderBackgroundColor(Color headerBackgroundColor) {
        this.setCssStyle("> .panel-heading", "background-color", headerBackgroundColor != null ? headerBackgroundColor.toHtmlColorString() : null);
    }

    public void setHeaderFontColor(Color headerFontColor) {
        this.setCssStyle("> .panel-heading > .panel-title", "color", headerFontColor.toHtmlColorString());
    }

    public void setBodyBackgroundColor(Color bodyBackgroundColor) {
        this.setCssStyle("> .panel-body", "background-color", bodyBackgroundColor != null ? bodyBackgroundColor.toHtmlColorString() : null);
    }

    public HeaderComponentMinimizationPolicy getHeaderComponentMinimizationPolicy() {
        return this.headerComponentMinimizationPolicy;
    }

    public void setHeaderComponentMinimizationPolicy(HeaderComponentMinimizationPolicy headerComponentMinimizationPolicy) {
        boolean changed = headerComponentMinimizationPolicy != this.headerComponentMinimizationPolicy;
        this.headerComponentMinimizationPolicy = headerComponentMinimizationPolicy;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isHideTitleBar() {
        return this.hideTitleBar;
    }

    public void setHideTitleBar(boolean hideTitleBar) {
        boolean changed = hideTitleBar != this.hideTitleBar;
        this.hideTitleBar = hideTitleBar;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
        this.reRenderIfRendered();
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        boolean changed = padding != this.padding;
        this.padding = padding;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isMaximizable() {
        return this.windowButtons.contains((Object)WindowButtonType.MAXIMIZE_RESTORE);
    }

    public void setMaximizable(boolean maximizable) {
        if (maximizable) {
            this.windowButtons.add(WindowButtonType.MAXIMIZE_RESTORE);
        } else {
            this.windowButtons.remove((Object)WindowButtonType.MAXIMIZE_RESTORE);
        }
        this.updateWindowButtons();
    }

    public void setLeftHeaderField(AbstractField<?> leftHeaderField) {
        if (this.leftHeaderField != null) {
            this.leftHeaderField.setParent(null);
        }
        this.leftHeaderField = leftHeaderField;
        leftHeaderField.setParent(this);
        this.queueCommandIfRendered(() -> new UiPanel.SetLeftHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(leftHeaderField, this.leftHeaderFieldIcon, this.leftHeaderFieldMinWidth, this.leftHeaderFieldMaxWidth)));
    }

    public Icon getLeftHeaderFieldIcon() {
        return this.leftHeaderFieldIcon;
    }

    public void setLeftHeaderFieldIcon(Icon leftHeaderFieldIcon) {
        this.leftHeaderFieldIcon = leftHeaderFieldIcon;
        this.queueCommandIfRendered(() -> new UiPanel.SetLeftHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.leftHeaderField, leftHeaderFieldIcon, this.leftHeaderFieldMinWidth, this.leftHeaderFieldMaxWidth)));
    }

    public int getLeftHeaderFieldMinWidth() {
        return this.leftHeaderFieldMinWidth;
    }

    public void setLeftHeaderFieldMinWidth(int leftHeaderFieldMinWidth) {
        this.leftHeaderFieldMinWidth = leftHeaderFieldMinWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetLeftHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.leftHeaderField, this.leftHeaderFieldIcon, leftHeaderFieldMinWidth, this.leftHeaderFieldMaxWidth)));
    }

    public int getLeftHeaderFieldMaxWidth() {
        return this.leftHeaderFieldMaxWidth;
    }

    public void setLeftHeaderFieldMaxWidth(int leftHeaderFieldMaxWidth) {
        this.leftHeaderFieldMaxWidth = leftHeaderFieldMaxWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetLeftHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.leftHeaderField, this.leftHeaderFieldIcon, this.leftHeaderFieldMinWidth, leftHeaderFieldMaxWidth)));
    }

    public void setRightHeaderField(AbstractField<?> rightHeaderField) {
        if (this.rightHeaderField != null) {
            this.rightHeaderField.setParent(null);
        }
        this.rightHeaderField = rightHeaderField;
        rightHeaderField.setParent(this);
        this.queueCommandIfRendered(() -> new UiPanel.SetRightHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(rightHeaderField, this.rightHeaderFieldIcon, this.rightHeaderFieldMinWidth, this.rightHeaderFieldMaxWidth)));
    }

    public Icon getRightHeaderFieldIcon() {
        return this.rightHeaderFieldIcon;
    }

    public void setRightHeaderFieldIcon(Icon rightHeaderFieldIcon) {
        this.rightHeaderFieldIcon = rightHeaderFieldIcon;
        this.queueCommandIfRendered(() -> new UiPanel.SetRightHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.rightHeaderField, rightHeaderFieldIcon, this.rightHeaderFieldMinWidth, this.rightHeaderFieldMaxWidth)));
    }

    public int getRightHeaderFieldMinWidth() {
        return this.rightHeaderFieldMinWidth;
    }

    public void setRightHeaderFieldMinWidth(int rightHeaderFieldMinWidth) {
        this.rightHeaderFieldMinWidth = rightHeaderFieldMinWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetRightHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.rightHeaderField, this.rightHeaderFieldIcon, rightHeaderFieldMinWidth, this.rightHeaderFieldMaxWidth)));
    }

    public int getRightHeaderFieldMaxWidth() {
        return this.rightHeaderFieldMaxWidth;
    }

    public void setRightHeaderFieldMaxWidth(int rightHeaderFieldMaxWidth) {
        this.rightHeaderFieldMaxWidth = rightHeaderFieldMaxWidth;
        this.queueCommandIfRendered(() -> new UiPanel.SetRightHeaderFieldCommand(this.getId(), this.createUiPanelHeaderField(this.rightHeaderField, this.rightHeaderFieldIcon, this.rightHeaderFieldMinWidth, rightHeaderFieldMaxWidth)));
    }

    public boolean isAlwaysShowHeaderFieldIcons() {
        return this.alwaysShowHeaderFieldIcons;
    }

    public void setAlwaysShowHeaderFieldIcons(boolean alwaysShowHeaderFieldIcons) {
        boolean changed = alwaysShowHeaderFieldIcons != this.alwaysShowHeaderFieldIcons;
        this.alwaysShowHeaderFieldIcons = alwaysShowHeaderFieldIcons;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isStretchContent() {
        return this.stretchContent;
    }

    public void setStretchContent(boolean stretchContent) {
        this.stretchContent = stretchContent;
        this.queueCommandIfRendered(() -> new UiPanel.SetStretchContentCommand(this.getId(), stretchContent));
    }

    public void setIcon(ObservableValue<Icon> observableIcon) {
        if (this.observableIcon != null) {
            this.observableIcon.onChanged().removeListener(this.iconChangeListener);
        }
        this.observableIcon = observableIcon;
        if (this.observableIcon != null) {
            this.setIcon(observableIcon.get());
            this.observableIcon.onChanged().addListener(this.iconChangeListener);
        }
    }

    public void setTitle(ObservableValue<String> observableTitle) {
        if (this.observableTitle != null) {
            this.observableTitle.onChanged().removeListener(this.titleChangeListener);
        }
        this.observableTitle = observableTitle;
        if (this.observableTitle != null) {
            this.setTitle(observableTitle.get());
            this.observableTitle.onChanged().addListener(this.titleChangeListener);
        }
    }

    public void setLeftHeaderField(ObservableValue<AbstractField<?>> observableLeftHeaderField) {
        if (this.observableLeftHeaderField != null) {
            this.observableLeftHeaderField.onChanged().removeListener(this.leftHeaderFieldChangeListener);
        }
        this.observableLeftHeaderField = observableLeftHeaderField;
        if (this.observableLeftHeaderField != null) {
            this.setLeftHeaderField(observableLeftHeaderField.get());
            this.observableLeftHeaderField.onChanged().addListener(this.leftHeaderFieldChangeListener);
        }
    }

    public void setRightHeaderField(ObservableValue<AbstractField<?>> observableRightHeaderField) {
        if (this.observableRightHeaderField != null) {
            this.observableRightHeaderField.onChanged().removeListener(this.rightHeaderFieldChangeListener);
        }
        this.observableRightHeaderField = observableRightHeaderField;
        if (this.observableRightHeaderField != null) {
            this.setRightHeaderField(observableRightHeaderField.get());
            this.observableRightHeaderField.onChanged().addListener(this.rightHeaderFieldChangeListener);
        }
    }
}

