/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.Objects;
import org.teamapps.dto.UiLocation;

public class Location {
    private final String href;
    private final String origin;
    private final String protocol;
    private final String host;
    private final String hostname;
    private final Integer port;
    private final String pathname;
    private final String search;
    private final String hash;

    public Location(String href, String origin, String protocol, String host, String hostname, Integer port, String pathname, String search, String hash) {
        this.href = href;
        this.origin = origin;
        this.protocol = protocol;
        this.host = host;
        this.hostname = hostname;
        this.port = port;
        this.pathname = pathname;
        this.search = search;
        this.hash = hash;
    }

    public static Location fromUiLocation(UiLocation uiLocation) {
        if (uiLocation.getPathname().length() > 0 && !uiLocation.getPathname().startsWith("/")) {
            throw new IllegalArgumentException("Non-empty pathname must always start with a slash!");
        }
        return new Location(Objects.requireNonNull(uiLocation.getHref()), Objects.requireNonNull(uiLocation.getOrigin()), Objects.requireNonNull(uiLocation.getProtocol()), Objects.requireNonNull(uiLocation.getHost()), Objects.requireNonNull(uiLocation.getHostname()), uiLocation.getPort(), uiLocation.getPathname() != null ? uiLocation.getPathname() : "", uiLocation.getSearch() != null ? uiLocation.getSearch() : "", uiLocation.getHash() != null ? uiLocation.getHash() : "");
    }

    public String getHref() {
        return this.href;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getSearch() {
        return this.search;
    }

    public String getHash() {
        return this.hash;
    }
}

