/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.teamapps.dto.AbstractUiTimeField;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.session.DateTimeFormatDescriptor;

public abstract class AbstractTimeField<VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private boolean showDropDownButton = true;
    private boolean showClearButton = false;
    private ULocale locale = this.getSessionContext().getULocale();
    private DateTimeFormatDescriptor timeFormat = this.getSessionContext().getConfiguration().getTimeFormat();

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public void mapAbstractTimeFieldUiValues(AbstractUiTimeField uiTimeField) {
        this.mapAbstractFieldAttributesToUiField((UiField)uiTimeField);
        uiTimeField.setShowDropDownButton(this.isShowDropDownButton());
        uiTimeField.setLocale(this.locale.toLanguageTag());
        uiTimeField.setTimeFormat(this.timeFormat.toDateTimeFormatDescriptor());
        uiTimeField.setShowClearButton(this.isShowClearButton());
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiTimeField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.queueCommandIfRendered(() -> new AbstractUiTimeField.SetLocaleAndTimeFormatCommand(this.getId(), locale.toLanguageTag(), this.timeFormat.toDateTimeFormatDescriptor()));
    }

    public DateTimeFormatDescriptor getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateTimeFormatDescriptor timeFormat) {
        this.timeFormat = timeFormat;
        this.queueCommandIfRendered(() -> new AbstractUiTimeField.SetLocaleAndTimeFormatCommand(this.getId(), this.locale.toLanguageTag(), timeFormat.toDateTimeFormatDescriptor()));
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new AbstractUiTimeField.SetShowClearButtonCommand(this.getId(), showClearButton));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

