/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiNotificationBarItem;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.animation.RepeatableAnimation;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.notification.NotificationBarItemClosedEvent;
import org.teamapps.ux.session.SessionContext;

public class NotificationBarItem {
    public final Event<Void> onClicked = new Event();
    public final Event<Void> onActionLinkClicked = new Event();
    public final Event<NotificationBarItemClosedEvent.ClosingReason> onClosed = new Event();
    private final String uiId = UUID.randomUUID().toString();
    private NotificationBarItemChangeListener listener;
    private Icon<?, ?> icon;
    private String text;
    private String actionLinkText;
    private RepeatableAnimation iconAnimation;
    private boolean dismissible;
    private int displayTimeInMillis;
    private boolean progressBarVisible;
    private Color backgroundColor;
    private Color borderColor;
    private Color textColor;
    private Color actionLinkColor;
    private Spacing padding;
    private EntranceAnimation entranceAnimation;
    private ExitAnimation exitAnimation;

    public NotificationBarItem() {
    }

    public NotificationBarItem(String text) {
        this(null, text, true);
    }

    public NotificationBarItem(Icon<?, ?> icon, String text) {
        this(icon, text, true);
    }

    public NotificationBarItem(Icon<?, ?> icon, String text, boolean dismissible) {
        this(icon, text, dismissible, 0, false);
    }

    public NotificationBarItem(Icon<?, ?> icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible) {
        this(icon, text, dismissible, displayTimeInMillis, progressBarVisible, null, null, null, null, null);
    }

    public NotificationBarItem(Icon<?, ?> icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible, Color backgroundColor, Color borderColor, Color textColor, Spacing padding, RepeatableAnimation iconAnimation) {
        this(icon, text, dismissible, displayTimeInMillis, progressBarVisible, backgroundColor, borderColor, textColor, padding, iconAnimation, EntranceAnimation.FADE_IN_DOWN, ExitAnimation.FADE_OUT_UP);
    }

    public NotificationBarItem(Icon<?, ?> icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible, Color backgroundColor, Color borderColor, Color textColor, Spacing padding, RepeatableAnimation iconAnimation, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.icon = icon;
        this.text = text;
        this.dismissible = dismissible;
        this.displayTimeInMillis = displayTimeInMillis;
        this.progressBarVisible = progressBarVisible;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.textColor = textColor;
        this.padding = padding;
        this.iconAnimation = iconAnimation;
        this.entranceAnimation = entranceAnimation;
        this.exitAnimation = exitAnimation;
    }

    public UiNotificationBarItem toUiNotificationBarItem() {
        UiNotificationBarItem ui = new UiNotificationBarItem();
        ui.setId(this.uiId);
        ui.setIcon(SessionContext.current().resolveIcon(this.icon));
        ui.setIconAnimation(this.iconAnimation != null ? this.iconAnimation.toUiRepeatableAnimation() : null);
        ui.setText(this.text);
        ui.setActionLinkText(this.actionLinkText);
        ui.setDismissible(this.dismissible);
        ui.setDisplayTimeInMillis(this.displayTimeInMillis);
        ui.setProgressBarVisible(this.progressBarVisible);
        ui.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        ui.setBorderColor(this.borderColor != null ? this.borderColor.toHtmlColorString() : null);
        ui.setTextColor(this.textColor != null ? this.textColor.toHtmlColorString() : null);
        ui.setActionLinkColor(this.actionLinkColor != null ? this.actionLinkColor.toHtmlColorString() : null);
        ui.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        return ui;
    }

    public String getUiId() {
        return this.uiId;
    }

    public void setListener(NotificationBarItemChangeListener listener) {
        this.listener = listener;
    }

    private void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.handleChagned();
        }
    }

    public Icon<?, ?> getIcon() {
        return this.icon;
    }

    public NotificationBarItem setIcon(Icon<?, ?> icon) {
        this.icon = icon;
        this.fireChangeEvent();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public NotificationBarItem setText(String text) {
        this.text = text;
        this.fireChangeEvent();
        return this;
    }

    public String getActionLinkText() {
        return this.actionLinkText;
    }

    public NotificationBarItem setActionLinkText(String actionLinkText) {
        this.actionLinkText = actionLinkText;
        this.fireChangeEvent();
        return this;
    }

    public RepeatableAnimation getIconAnimation() {
        return this.iconAnimation;
    }

    public NotificationBarItem setIconAnimation(RepeatableAnimation iconAnimation) {
        this.iconAnimation = iconAnimation;
        this.fireChangeEvent();
        return this;
    }

    public boolean isDismissible() {
        return this.dismissible;
    }

    public NotificationBarItem setDismissible(boolean dismissible) {
        this.dismissible = dismissible;
        this.fireChangeEvent();
        return this;
    }

    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    public NotificationBarItem setDisplayTimeInMillis(int displayTimeInMillis) {
        this.displayTimeInMillis = displayTimeInMillis;
        this.fireChangeEvent();
        return this;
    }

    public boolean isProgressBarVisible() {
        return this.progressBarVisible;
    }

    public NotificationBarItem setProgressBarVisible(boolean progressBarVisible) {
        this.progressBarVisible = progressBarVisible;
        this.fireChangeEvent();
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public NotificationBarItem setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.fireChangeEvent();
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public NotificationBarItem setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.fireChangeEvent();
        return this;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public NotificationBarItem setTextColor(Color textColor) {
        this.textColor = textColor;
        this.fireChangeEvent();
        return this;
    }

    public Color getActionLinkColor() {
        return this.actionLinkColor;
    }

    public NotificationBarItem setActionLinkColor(Color actionLinkColor) {
        this.actionLinkColor = actionLinkColor;
        this.fireChangeEvent();
        return this;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public NotificationBarItem setPadding(Spacing padding) {
        this.padding = padding;
        this.fireChangeEvent();
        return this;
    }

    public EntranceAnimation getEntranceAnimation() {
        return this.entranceAnimation;
    }

    public NotificationBarItem setEntranceAnimation(EntranceAnimation entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
        this.fireChangeEvent();
        return this;
    }

    public ExitAnimation getExitAnimation() {
        return this.exitAnimation;
    }

    public NotificationBarItem setExitAnimation(ExitAnimation exitAnimation) {
        this.exitAnimation = exitAnimation;
        this.fireChangeEvent();
        return this;
    }

    static interface NotificationBarItemChangeListener {
        public void handleChagned();
    }
}

