/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.glassfish.jersey.uri.UriTemplate;
import org.junit.Test;

public class BaseRoutingTest {
    @Test
    public void pathRemainderSuffix() {
        UriTemplate uriTemplate = new UriTemplate("/asdf/x{_remainder:(/.*)?}");
        BaseRoutingTest.testUriPatternMatches(uriTemplate, "/asdf/x", Assertions.entry((Object)"_remainder", (Object)""));
        BaseRoutingTest.testUriPatternMatches(uriTemplate, "/asdf/x/foo", Assertions.entry((Object)"_remainder", (Object)"/foo"));
        Assertions.assertThat((boolean)uriTemplate.match((CharSequence)"/asdf/xyz", new HashMap())).isFalse();
    }

    @SafeVarargs
    private static void testUriPatternMatches(UriTemplate uriTemplate, String path, MapEntry<String, String> ... expectedEntries) {
        HashMap map = new HashMap();
        Assertions.assertThat((boolean)uriTemplate.match((CharSequence)path, map)).isTrue();
        Assertions.assertThat(map).containsOnly(expectedEntries);
    }
}

