/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.RoutingUtil;

public class RoutingUtilTest {
    @Test
    public void normalizePathPrefix() {
        Assertions.assertThat((String)RoutingUtil.normalizePath(null)).isEqualTo("/");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"")).isEqualTo("/");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/")).isEqualTo("/");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"foo")).isEqualTo("/foo");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/foo")).isEqualTo("/foo");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"foo/bar")).isEqualTo("/foo/bar");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/foo/bar")).isEqualTo("/foo/bar");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"foo/bar/")).isEqualTo("/foo/bar");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/foo/bar/")).isEqualTo("/foo/bar");
    }

    @Test
    public void withSingleLeadingSlash() {
        Assertions.assertThat((String)RoutingUtil.normalizePath(null)).isEqualTo("/");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/")).isEqualTo("/");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"foo")).isEqualTo("/foo");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/foo")).isEqualTo("/foo");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"//foo")).isEqualTo("/foo");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"foo/bar")).isEqualTo("/foo/bar");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"/foo/bar")).isEqualTo("/foo/bar");
        Assertions.assertThat((String)RoutingUtil.normalizePath((String)"//foo/bar/")).isEqualTo("/foo/bar");
    }

    @Test
    public void concatenatePaths() {
        Assertions.assertThat((String)RoutingUtil.concatenatePaths(null, (String)"asdf")).isEqualTo("/asdf");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"", (String)"asdf")).isEqualTo("/asdf");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"/", (String)"asdf")).isEqualTo("/asdf");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"/", (String)"/asdf")).isEqualTo("/asdf");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"prefix", (String)"suffix")).isEqualTo("/prefix/suffix");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"/prefix", (String)"suffix")).isEqualTo("/prefix/suffix");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"prefix", (String)"/suffix")).isEqualTo("/prefix/suffix");
        Assertions.assertThat((String)RoutingUtil.concatenatePaths((String)"/prefix", (String)"/suffix")).isEqualTo("/prefix/suffix");
    }
}

