/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiButton;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;

public class Button<RECORD>
extends AbstractField<Void> {
    public final Event<Void> onClicked = new Event();
    public final Event<Void> onDropDownOpened = new Event();
    private Template template;
    private RECORD templateRecord;
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();
    private boolean openDropDownIfNotSet = false;
    private Component dropDownComponent;
    private Integer minDropDownWidth = null;
    private Integer minDropDownHeight = 300;
    private String onClickJavaScript;

    public Button(Template template, RECORD templateRecord, Component dropDownComponent) {
        this.template = template;
        this.templateRecord = templateRecord;
        this.dropDownComponent = dropDownComponent;
    }

    public Button(Template template, RECORD templateRecord) {
        this(template, templateRecord, null);
    }

    public static Button<BaseTemplateRecord> create(BaseTemplate template, Icon icon, String caption, Component dropDownComponent) {
        return new Button<BaseTemplateRecord>(template, new BaseTemplateRecord(icon, caption), dropDownComponent);
    }

    public static Button<BaseTemplateRecord> create(BaseTemplate template, Icon icon, String caption) {
        return Button.create(template, icon, caption, null);
    }

    public static Button<BaseTemplateRecord> create(BaseTemplate template, String caption) {
        return Button.create(template, null, caption, null);
    }

    public static Button<BaseTemplateRecord> create(Icon icon, String caption, Component dropDownComponent) {
        return Button.create(BaseTemplate.BUTTON, icon, caption, dropDownComponent);
    }

    public static Button<BaseTemplateRecord> create(String caption, Component dropDownComponent) {
        return Button.create(BaseTemplate.BUTTON, null, caption, dropDownComponent);
    }

    public static Button<BaseTemplateRecord> create(Icon icon, String caption) {
        return Button.create(BaseTemplate.BUTTON, icon, caption, null);
    }

    public static Button<BaseTemplateRecord> create(String caption) {
        return Button.create(BaseTemplate.BUTTON, null, caption, null);
    }

    public UiField createUiComponent() {
        Object uiRecord = this.createUiRecord();
        UiButton ui = new UiButton(this.template != null ? this.template.createUiTemplate() : null, uiRecord);
        this.mapAbstractFieldAttributesToUiField((UiField)ui);
        ui.setDropDownComponent(Component.createUiClientObjectReference(this.dropDownComponent));
        ui.setMinDropDownWidth(this.minDropDownWidth != null ? this.minDropDownWidth : 0);
        ui.setMinDropDownHeight(this.minDropDownHeight != null ? this.minDropDownHeight : 0);
        ui.setOpenDropDownIfNotSet(this.openDropDownIfNotSet);
        ui.setOnClickJavaScript(this.onClickJavaScript);
        return ui;
    }

    private Object createUiRecord() {
        Object uiRecord = this.template != null ? this.propertyProvider.getValues(this.templateRecord, this.template.getPropertyNames()) : this.templateRecord.toString();
        return uiRecord;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_BUTTON_CLICKED: {
                this.onClicked.fire();
                break;
            }
            case UI_BUTTON_DROP_DOWN_OPENED: {
                this.onDropDownOpened.fire(null);
            }
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public Button<RECORD> setTemplate(Template template) {
        this.template = template;
        this.queueCommandIfRendered(() -> new UiButton.SetTemplateCommand(this.getId(), template.createUiTemplate(), this.createUiRecord()));
        return this;
    }

    public RECORD getTemplateRecord() {
        return this.templateRecord;
    }

    public Button<RECORD> setTemplateRecord(RECORD templateRecord) {
        this.templateRecord = templateRecord;
        this.queueCommandIfRendered(() -> new UiButton.SetTemplateRecordCommand(this.getId(), templateRecord));
        return this;
    }

    public Button<RECORD> setColor(Color color) {
        this.setCssStyle(".btn", "background-color", color != null ? color.toHtmlColorString() : null);
        return this;
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyProvider = propertyExtractor;
    }

    public Integer getMinDropDownWidth() {
        return this.minDropDownWidth;
    }

    public Button<RECORD> setMinDropDownWidth(Integer minDropDownWidth) {
        this.minDropDownWidth = minDropDownWidth;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), minDropDownWidth != null ? minDropDownWidth : 0, this.minDropDownHeight != null ? this.minDropDownHeight : 0));
        return this;
    }

    public Integer getMinDropDownHeight() {
        return this.minDropDownHeight;
    }

    public Button<RECORD> setMinDropDownHeight(Integer minDropDownHeight) {
        this.minDropDownHeight = minDropDownHeight;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), this.minDropDownWidth != null ? this.minDropDownWidth : 0, minDropDownHeight != null ? minDropDownHeight : 0));
        return this;
    }

    public Button<RECORD> setMinDropDownSize(Integer minDropDownWidth, Integer minDropDownHeight) {
        this.minDropDownWidth = minDropDownWidth;
        this.minDropDownHeight = minDropDownHeight;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), minDropDownWidth.intValue(), minDropDownHeight.intValue()));
        return this;
    }

    public boolean isOpenDropDownIfNotSet() {
        return this.openDropDownIfNotSet;
    }

    public Button<RECORD> setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
        this.openDropDownIfNotSet = openDropDownIfNotSet;
        this.queueCommandIfRendered(() -> new UiButton.SetOpenDropDownIfNotSetCommand(this.getId(), openDropDownIfNotSet));
        return this;
    }

    public Component getDropDownComponent() {
        return this.dropDownComponent;
    }

    public Button<RECORD> setDropDownComponent(Component dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownComponentCommand(this.getId(), Component.createUiClientObjectReference(dropDownComponent)));
        return this;
    }

    public void closeDropDown() {
        this.queueCommandIfRendered(() -> new UiButton.CloseDropDownCommand(this.getId()));
    }

    public String getOnClickJavaScript() {
        return this.onClickJavaScript;
    }

    public void setOnClickJavaScript(String onClickJavaScript) {
        this.onClickJavaScript = onClickJavaScript;
        this.queueCommandIfRendered(() -> new UiButton.SetOnClickJavaScriptCommand(this.getId(), onClickJavaScript));
    }
}

