/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiCheckBox;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.field.AbstractField;

public class CheckBox
extends AbstractField<Boolean> {
    private String caption;
    private Color backgroundColor = new RgbaColor(255, 255, 255);
    private Color checkColor = new RgbaColor(70, 70, 70);
    private Color borderColor = new RgbaColor(204, 204, 204);
    private boolean htmlEnabled = false;

    public CheckBox(String caption) {
        this.setValue(false);
        this.caption = caption;
    }

    public CheckBox() {
        this(null);
    }

    public UiField createUiComponent() {
        UiCheckBox uiCheckBox = new UiCheckBox();
        this.mapAbstractFieldAttributesToUiField((UiField)uiCheckBox);
        uiCheckBox.setCaption(this.caption);
        uiCheckBox.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        uiCheckBox.setCheckColor(this.checkColor != null ? this.checkColor.toHtmlColorString() : null);
        uiCheckBox.setBorderColor(this.borderColor != null ? this.borderColor.toHtmlColorString() : null);
        uiCheckBox.setHtmlEnabled(this.htmlEnabled);
        return uiCheckBox;
    }

    public String getCaption() {
        return this.caption;
    }

    public CheckBox setCaption(String caption) {
        this.caption = caption;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetCaptionCommand(this.getId(), caption));
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public CheckBox setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetBackgroundColorCommand(this.getId(), backgroundColor != null ? backgroundColor.toHtmlColorString() : null));
        return this;
    }

    public Color getCheckColor() {
        return this.checkColor;
    }

    public CheckBox setCheckColor(Color checkColor) {
        this.checkColor = checkColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetCheckColorCommand(this.getId(), checkColor != null ? checkColor.toHtmlColorString() : null));
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public CheckBox setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetBorderColorCommand(this.getId(), borderColor != null ? borderColor.toHtmlColorString() : null));
        return this;
    }

    public boolean isHtmlEnabled() {
        return this.htmlEnabled;
    }

    public CheckBox setHtmlEnabled(boolean htmlEnabled) {
        boolean changed = htmlEnabled != this.htmlEnabled;
        this.htmlEnabled = htmlEnabled;
        if (changed) {
            this.reRenderIfRendered();
        }
        return this;
    }
}

