/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.combobox;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.AbstractUiComboBox;
import org.teamapps.dto.UiComboBoxTreeRecord;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiTextInputHandlingField;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.record.legacy.CacheManipulationHandle;
import org.teamapps.ux.cache.record.legacy.ClientRecordCache;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.ComboBoxModel;

public abstract class AbstractComboBox<RECORD, VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComboBox.class);
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    protected final ClientRecordCache<RECORD, UiComboBoxTreeRecord> recordCache;
    private ComboBoxModel<RECORD> model;
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private int templateIdCounter = 0;
    private Template selectedEntryTemplate = null;
    private Template dropDownTemplate = null;
    private TemplateDecider<RECORD> selectedEntryTemplateDecider = record -> this.selectedEntryTemplate;
    private TemplateDecider<RECORD> dropdownTemplateDecider = record -> this.dropDownTemplate;
    private boolean dropDownButtonVisible = true;
    private boolean showDropDownAfterResultsArrive = false;
    private boolean highlightFirstResultEntry = true;
    private boolean autoComplete = true;
    private boolean showHighlighting = false;
    private int textHighlightingEntryLimit = 100;
    private boolean allowFreeText;
    private boolean showClearButton;
    private boolean animate = true;
    private boolean showExpanders = false;
    private String emptyText;
    private Integer dropDownMinWidth;
    private Integer dropDownMaxHeight;
    private boolean distinctModelResultFiltering = false;
    private Function<RECORD, String> recordToStringFunction = Object::toString;
    protected Function<String, RECORD> freeTextRecordFactory = null;

    protected AbstractComboBox(ComboBoxModel<RECORD> model) {
        this.model = model;
        this.recordCache = new ClientRecordCache<Object, UiComboBoxTreeRecord>(this::createUiTreeRecordWithoutParentRelation, this::addParentLinkToUiRecord);
    }

    protected AbstractComboBox() {
        this(query -> Collections.emptyList());
    }

    protected void mapCommonUiComboBoxProperties(AbstractUiComboBox ui) {
        this.mapAbstractFieldAttributesToUiField((UiField)ui);
        ui.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        ui.setShowDropDownButton(this.dropDownButtonVisible);
        ui.setShowDropDownAfterResultsArrive(this.showDropDownAfterResultsArrive);
        ui.setHighlightFirstResultEntry(this.highlightFirstResultEntry);
        ui.setShowHighlighting(this.showHighlighting);
        ui.setAutoComplete(this.autoComplete);
        ui.setTextHighlightingEntryLimit(this.textHighlightingEntryLimit);
        ui.setAllowAnyText(this.allowFreeText);
        ui.setShowClearButton(this.showClearButton);
        ui.setAnimate(this.animate);
        ui.setShowExpanders(this.showExpanders);
        ui.setPlaceholderText(this.emptyText);
        ui.setDropDownMinWidth(this.dropDownMinWidth);
        ui.setDropDownMaxHeight(this.dropDownMaxHeight);
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_TEXT_INPUT_HANDLING_FIELD_TEXT_INPUT: {
                UiTextInputHandlingField.TextInputEvent keyStrokeEvent = (UiTextInputHandlingField.TextInputEvent)event;
                String string = keyStrokeEvent.getEnteredString() != null ? keyStrokeEvent.getEnteredString() : "";
                this.onTextInput.fire(string);
                break;
            }
            case UI_TEXT_INPUT_HANDLING_FIELD_SPECIAL_KEY_PRESSED: {
                UiTextInputHandlingField.SpecialKeyPressedEvent specialKeyPressedEvent = (UiTextInputHandlingField.SpecialKeyPressedEvent)event;
                this.onSpecialKeyPressed.fire(SpecialKey.valueOf(specialKeyPressedEvent.getKey().name()));
            }
        }
    }

    @Override
    public Object handleUiQuery(UiQuery query) {
        switch (query.getUiQueryType()) {
            case ABSTRACT_UI_COMBO_BOX_RETRIEVE_DROPDOWN_ENTRIES: {
                String string;
                AbstractUiComboBox.RetrieveDropdownEntriesQuery q = (AbstractUiComboBox.RetrieveDropdownEntriesQuery)query;
                String string2 = string = q.getQueryString() != null ? q.getQueryString() : "";
                if (this.model != null) {
                    List<RECORD> resultRecords = this.model.getRecords(string);
                    if (this.distinctModelResultFiltering) {
                        resultRecords = this.filterOutSelected(resultRecords);
                    }
                    CacheManipulationHandle<List<UiComboBoxTreeRecord>> cacheResponse = this.recordCache.replaceRecords(resultRecords);
                    cacheResponse.commit();
                    return cacheResponse.getAndClearResult();
                }
                return List.of();
            }
            case ABSTRACT_UI_COMBO_BOX_LAZY_CHILDREN: {
                AbstractUiComboBox.LazyChildrenQuery lazyChildrenQuery = (AbstractUiComboBox.LazyChildrenQuery)query;
                RECORD parentRecord = this.recordCache.getRecordByClientId(lazyChildrenQuery.getParentId());
                if (parentRecord != null) {
                    if (this.model == null) break;
                    List<RECORD> childRecords = this.model.getChildRecords(parentRecord);
                    if (this.distinctModelResultFiltering) {
                        childRecords = this.filterOutSelected(childRecords);
                    }
                    CacheManipulationHandle<List<UiComboBoxTreeRecord>> cacheResponse = this.recordCache.addRecords(childRecords);
                    cacheResponse.commit();
                    return cacheResponse.getAndClearResult();
                }
                return Collections.emptyList();
            }
        }
        return super.handleUiQuery(query);
    }

    private List<RECORD> filterOutSelected(List<RECORD> resultRecords) {
        Set selectedRecords = this.getSelectedRecords();
        resultRecords = resultRecords.stream().filter(r -> !selectedRecords.contains(r)).collect(Collectors.toList());
        return resultRecords;
    }

    protected abstract Set<RECORD> getSelectedRecords();

    protected UiComboBoxTreeRecord createUiTreeRecordWithoutParentRelation(RECORD record) {
        if (record == null) {
            return null;
        }
        Template displayTemplate = this.getTemplateForRecord(record, this.selectedEntryTemplateDecider, this.selectedEntryTemplate);
        Template dropdownTemplate = this.getTemplateForRecord(record, this.dropdownTemplateDecider, this.dropDownTemplate);
        HashSet<String> templatePropertyNames = new HashSet<String>();
        templatePropertyNames.addAll(displayTemplate != null ? displayTemplate.getPropertyNames() : Collections.emptySet());
        templatePropertyNames.addAll(dropdownTemplate != null ? dropdownTemplate.getPropertyNames() : Collections.emptySet());
        Map<String, Object> values = this.propertyProvider.getValues(record, templatePropertyNames);
        UiComboBoxTreeRecord uiTreeRecord = new UiComboBoxTreeRecord();
        uiTreeRecord.setValues(values);
        uiTreeRecord.setDisplayTemplateId(this.templateIdsByTemplate.get(displayTemplate));
        uiTreeRecord.setDropDownTemplateId(this.templateIdsByTemplate.get(dropdownTemplate));
        uiTreeRecord.setAsString(this.recordToStringFunction.apply(record));
        TreeNodeInfo treeNodeInfo = this.model.getTreeNodeInfo(record);
        if (treeNodeInfo != null) {
            uiTreeRecord.setExpanded(treeNodeInfo.isExpanded());
            uiTreeRecord.setLazyChildren(treeNodeInfo.isLazyChildren());
            uiTreeRecord.setSelectable(treeNodeInfo.isSelectable());
        }
        return uiTreeRecord;
    }

    protected void addParentLinkToUiRecord(RECORD record, UiComboBoxTreeRecord uiTreeRecord, Map<RECORD, UiComboBoxTreeRecord> othersCurrentlyBeingAddedToCache) {
        Object parent;
        TreeNodeInfo treeNodeInfo = this.model.getTreeNodeInfo(record);
        if (treeNodeInfo != null && (parent = treeNodeInfo.getParent()) != null) {
            UiComboBoxTreeRecord uiParentFromOthers = othersCurrentlyBeingAddedToCache.get(parent);
            if (uiParentFromOthers != null) {
                uiTreeRecord.setParentId(Integer.valueOf(uiParentFromOthers.getId()));
            } else {
                Integer cachedParentUiRecordId = this.recordCache.getUiRecordIdOrNull(parent);
                if (cachedParentUiRecordId != null) {
                    uiTreeRecord.setParentId(cachedParentUiRecordId);
                }
            }
        }
    }

    private Template getTemplateForRecord(RECORD record, TemplateDecider<RECORD> templateDecider, Template defaultTemplate) {
        Template template;
        Template templateFromDecider = templateDecider.getTemplate(record);
        Template template2 = template = templateFromDecider != null ? templateFromDecider : defaultTemplate;
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String uuid = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, uuid);
            this.queueCommandIfRendered(() -> new AbstractUiComboBox.RegisterTemplateCommand(this.getId(), uuid, template.createUiTemplate()));
        }
        return template;
    }

    protected boolean isFreeTextEntry(UiComboBoxTreeRecord uiTreeRecord) {
        return uiTreeRecord.getId() < 0;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public ComboBoxModel<RECORD> getModel() {
        return this.model;
    }

    public void setModel(ComboBoxModel<RECORD> model) {
        this.model = model;
        this.reRenderIfRendered();
    }

    public boolean isDropDownButtonVisible() {
        return this.dropDownButtonVisible;
    }

    public boolean isShowDropDownAfterResultsArrive() {
        return this.showDropDownAfterResultsArrive;
    }

    public boolean isHighlightFirstResultEntry() {
        return this.highlightFirstResultEntry;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public boolean isShowHighlighting() {
        return this.showHighlighting;
    }

    public int getTextHighlightingEntryLimit() {
        return this.textHighlightingEntryLimit;
    }

    public boolean isAllowFreeText() {
        return this.allowFreeText;
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setDropDownButtonVisible(boolean dropDownButtonVisible) {
        boolean changed = dropDownButtonVisible != this.dropDownButtonVisible;
        this.dropDownButtonVisible = dropDownButtonVisible;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setShowDropDownAfterResultsArrive(boolean showDropDownAfterResultsArrive) {
        boolean changed = showDropDownAfterResultsArrive != this.showDropDownAfterResultsArrive;
        this.showDropDownAfterResultsArrive = showDropDownAfterResultsArrive;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setHighlightFirstResultEntry(boolean highlightFirstResultEntry) {
        boolean changed = highlightFirstResultEntry != this.highlightFirstResultEntry;
        this.highlightFirstResultEntry = highlightFirstResultEntry;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setAutoComplete(boolean autoComplete) {
        boolean changed = autoComplete != this.autoComplete;
        this.autoComplete = autoComplete;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setShowHighlighting(boolean showHighlighting) {
        boolean changed = showHighlighting != this.showHighlighting;
        this.showHighlighting = showHighlighting;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setAllowFreeText(boolean allowFreeText) {
        boolean changed = allowFreeText != this.allowFreeText;
        this.allowFreeText = allowFreeText;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setShowClearButton(boolean showClearButton) {
        boolean changed = showClearButton != this.showClearButton;
        this.showClearButton = showClearButton;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setAnimate(boolean animate) {
        boolean changed = animate != this.animate;
        this.animate = animate;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isShowExpanders() {
        return this.showExpanders;
    }

    public void setShowExpanders(boolean showExpanders) {
        boolean changed = showExpanders != this.showExpanders;
        this.showExpanders = showExpanders;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setSelectedEntryTemplate(Template selectedEntryTemplate) {
        this.selectedEntryTemplate = selectedEntryTemplate;
        if (selectedEntryTemplate != null) {
            this.templateIdsByTemplate.put(selectedEntryTemplate, "" + this.templateIdCounter++);
        }
        this.reRenderIfRendered();
    }

    public void setDropDownTemplate(Template dropDownTemplate) {
        this.dropDownTemplate = dropDownTemplate;
        if (dropDownTemplate != null) {
            this.templateIdsByTemplate.put(dropDownTemplate, "" + this.templateIdCounter++);
        }
        this.reRenderIfRendered();
    }

    public void setTemplate(Template template) {
        this.setSelectedEntryTemplate(template);
        this.setDropDownTemplate(template);
    }

    public void setTextHighlightingEntryLimit(int textHighlightingEntryLimit) {
        boolean changed = textHighlightingEntryLimit != this.textHighlightingEntryLimit;
        this.textHighlightingEntryLimit = textHighlightingEntryLimit;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public Template getSelectedEntryTemplate() {
        return this.selectedEntryTemplate;
    }

    public Template getDropDownTemplate() {
        return this.dropDownTemplate;
    }

    public TemplateDecider<RECORD> getSelectedEntryTemplateDecider() {
        return this.selectedEntryTemplateDecider;
    }

    public void setSelectedEntryTemplateDecider(TemplateDecider<RECORD> selectedEntryTemplateDecider) {
        this.selectedEntryTemplateDecider = selectedEntryTemplateDecider;
    }

    public TemplateDecider<RECORD> getDropdownTemplateDecider() {
        return this.dropdownTemplateDecider;
    }

    public void setDropdownTemplateDecider(TemplateDecider<RECORD> dropdownTemplateDecider) {
        this.dropdownTemplateDecider = dropdownTemplateDecider;
    }

    public void setTemplateDecider(TemplateDecider<RECORD> templateDecider) {
        this.selectedEntryTemplateDecider = templateDecider;
        this.dropdownTemplateDecider = templateDecider;
        this.reRenderIfRendered();
    }

    public Function<String, RECORD> getFreeTextRecordFactory() {
        return this.freeTextRecordFactory;
    }

    public void setFreeTextRecordFactory(Function<String, RECORD> freeTextRecordFactory) {
        this.freeTextRecordFactory = freeTextRecordFactory;
        this.reRenderIfRendered();
    }

    public Function<RECORD, String> getRecordToStringFunction() {
        return this.recordToStringFunction;
    }

    public void setRecordToStringFunction(Function<RECORD, String> recordToStringFunction) {
        this.recordToStringFunction = recordToStringFunction;
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        boolean changed = !Objects.equals(emptyText, this.emptyText);
        this.emptyText = emptyText;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isDistinctModelResultFiltering() {
        return this.distinctModelResultFiltering;
    }

    public void setDistinctModelResultFiltering(boolean distinctModelResultFiltering) {
        this.distinctModelResultFiltering = distinctModelResultFiltering;
    }

    public Integer getDropDownMinWidth() {
        return this.dropDownMinWidth;
    }

    public void setDropDownMinWidth(Integer dropDownMinWidth) {
        boolean changed = !Objects.equals(dropDownMinWidth, this.dropDownMinWidth);
        this.dropDownMinWidth = dropDownMinWidth;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public Integer getDropDownMaxHeight() {
        return this.dropDownMaxHeight;
    }

    public void setDropDownMaxHeight(Integer dropDownMaxHeight) {
        boolean changed = !Objects.equals(dropDownMaxHeight, this.dropDownMaxHeight);
        this.dropDownMaxHeight = dropDownMaxHeight;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

