/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.AbstractUiToolContainer;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiDropDownButtonClickInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.DropDownButtonClickInfo;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonClickEventData;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public abstract class AbstractToolContainer
extends AbstractComponent {
    public final Event<ToolbarButtonClickEventData> onButtonClick = new Event();
    protected List<ToolbarButtonGroup> buttonGroups = new ArrayList<ToolbarButtonGroup>();
    private Template buttonTemplate = BaseTemplate.TOOLBAR_BUTTON;
    private PropertyProvider propertyProvider = new BeanPropertyExtractor();

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case ABSTRACT_UI_TOOL_CONTAINER_TOOLBAR_BUTTON_CLICK: {
                Component dropdownComponent;
                AbstractUiToolContainer.ToolbarButtonClickEvent clickEvent = (AbstractUiToolContainer.ToolbarButtonClickEvent)event;
                ToolbarButton button = this.getButtonByClientId(clickEvent.getGroupId(), clickEvent.getButtonId());
                if (button == null) break;
                UiDropDownButtonClickInfo uiDropDownButtonClickInfo = clickEvent.getDropDownClickInfo();
                if (uiDropDownButtonClickInfo != null && uiDropDownButtonClickInfo.getIsOpening() && !uiDropDownButtonClickInfo.getIsContentSet() && (dropdownComponent = button.getDropDownComponent()) != null) {
                    this.getSessionContext().queueCommand((UiCommand<?>)new AbstractUiToolContainer.SetDropDownComponentCommand(this.getId(), clickEvent.getGroupId(), ((AbstractUiToolContainer.ToolbarButtonClickEvent)event).getButtonId(), dropdownComponent.createUiReference()));
                }
                button.onClick.fire(clickEvent);
                DropDownButtonClickInfo dropDownButtonClickInfo = uiDropDownButtonClickInfo != null ? new DropDownButtonClickInfo(uiDropDownButtonClickInfo.getIsOpening(), uiDropDownButtonClickInfo.getIsContentSet()) : null;
                this.onButtonClick.fire(new ToolbarButtonClickEventData(button, dropDownButtonClickInfo));
                break;
            }
        }
    }

    private ToolbarButton getButtonByClientId(String groupId, String buttonId) {
        return this.buttonGroups.stream().filter(group -> Objects.equals(group.getClientId(), groupId)).flatMap(group -> group.getButtons().stream()).filter(button -> Objects.equals(button.getClientId(), buttonId)).findAny().orElse(null);
    }

    public boolean isEmpty() {
        return this.buttonGroups.isEmpty();
    }

    public ToolbarButtonGroup addButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.buttonGroups.add(buttonGroup);
        buttonGroup.setToolContainer(this);
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.AddButtonGroupCommand(this.getId(), buttonGroup.createUiToolbarButtonGroup(), buttonGroup.isRightSide()));
        return buttonGroup;
    }

    public void removeAllToolbarButtonGroups() {
        List.copyOf(this.buttonGroups).forEach(this::removeToolbarButtonGroup);
    }

    public void removeToolbarButtonGroup(ToolbarButtonGroup group) {
        this.buttonGroups.remove(group);
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.RemoveButtonGroupCommand(this.getId(), group.getClientId()));
    }

    protected void handleGroupVisibilityChange(String groupId, boolean visible) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.SetButtonGroupVisibleCommand(this.getId(), groupId, visible));
    }

    protected void handleButtonVisibilityChange(String groupClientId, String buttonClientId, boolean visible) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.SetButtonVisibleCommand(this.getId(), groupClientId, buttonClientId, visible));
    }

    protected void handleButtonColorChange(String groupClientId, String buttonClientId, Color backgroundColor, Color hoverBackgroundColor) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.SetButtonColorsCommand(this.getId(), groupClientId, buttonClientId, backgroundColor != null ? backgroundColor.toHtmlColorString() : null, hoverBackgroundColor != null ? hoverBackgroundColor.toHtmlColorString() : null));
    }

    protected void handleAddButton(ToolbarButtonGroup group, ToolbarButton button, String neighborButtonId, boolean beforeNeighbor) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.AddButtonCommand(this.getId(), group.getClientId(), button.createUiToolbarButton(), neighborButtonId, beforeNeighbor));
    }

    protected void handleButtonRemoved(ToolbarButtonGroup group, ToolbarButton button) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.RemoveButtonCommand(this.getId(), group.getClientId(), button.getClientId()));
    }

    protected void handleButtonSetDropDownComponent(ToolbarButtonGroup group, ToolbarButton button, Component component) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.SetDropDownComponentCommand(this.getId(), group.getClientId(), button.getClientId(), component.createUiReference()));
    }

    protected void handleCloseDropdown(ToolbarButtonGroup group, ToolbarButton button) {
        this.queueCommandIfRendered(() -> new AbstractUiToolContainer.CloseDropDownCommand(this.getId(), group.getClientId(), button.getClientId()));
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.setCssStyle("> .background-color-div", "background-color", backgroundColor != null ? backgroundColor.toHtmlColorString() : null);
    }

    public List<ToolbarButtonGroup> getToolbarButtonGroups() {
        ArrayList<ToolbarButtonGroup> groups = new ArrayList<ToolbarButtonGroup>();
        groups.addAll(this.buttonGroups);
        return groups;
    }

    public Template getButtonTemplate() {
        return this.buttonTemplate;
    }

    public void setButtonTemplate(Template buttonTemplate) {
        this.buttonTemplate = buttonTemplate;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }
}

