/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.AnnotationBasedRoutingHandlerFactory;
import org.teamapps.ux.session.navigation.ParameterConverterProvider;
import org.teamapps.ux.session.navigation.annotation.PathParameter;
import org.teamapps.ux.session.navigation.annotation.QueryParameter;
import org.teamapps.ux.session.navigation.annotation.RoutingPath;

public class AnnotationBasedRoutingHandlerFactoryTest {
    @Test
    public void annotatedMethod() {
        final AtomicBoolean wasInvoked = new AtomicBoolean();
        AnnotationBasedRoutingHandlerFactory factory = new AnnotationBasedRoutingHandlerFactory((ParamConverterProvider)new ParameterConverterProvider());
        List routers = factory.createRouters(new Object(){

            @RoutingPath(value="/apps/{appName}/item/{itemId}")
            public void myMethod(@PathParameter(value="appName") String appName, @PathParameter(value="itemId") Integer id, @QueryParameter(value="flag") Boolean flag) {
                wasInvoked.set(true);
                Assertions.assertThat((String)appName).isEqualTo("myApp");
                Assertions.assertThat((Integer)id).isEqualTo(123);
                Assertions.assertThat((Boolean)flag).isTrue();
            }
        });
        Assertions.assertThat((List)routers).extracting(r -> r.getPathTemplate()).containsExactlyInAnyOrder((Object[])new String[]{"/apps/{appName}/item/{itemId}"});
        ((AnnotationBasedRoutingHandlerFactory.AnnotationBasedRoutingHandler)routers.get(0)).handle("/apps/myApp/item/123", Map.of("appName", "myApp", "itemId", "123"), Map.of("flag", "true"));
        Assertions.assertThat((AtomicBoolean)wasInvoked).isTrue();
    }

    @Test
    public void classLevelPathAnnotation() {
        AnnotationBasedRoutingHandlerFactory factory = new AnnotationBasedRoutingHandlerFactory((ParamConverterProvider)new ParameterConverterProvider());
        MyRouter router = new MyRouter();
        List routers = factory.createRouters((Object)router);
        Assertions.assertThat((List)routers).extracting(r -> r.getPathTemplate()).containsExactlyInAnyOrder((Object[])new String[]{"/foo/{x}/bar/{y}"});
        ((AnnotationBasedRoutingHandlerFactory.AnnotationBasedRoutingHandler)routers.get(0)).handle("/foo/111/bar/yyy", Map.of("x", "111", "y", "yyy"), Map.of());
        Assertions.assertThat((boolean)router.wasInvoked).isTrue();
    }

    @RoutingPath(value="foo/{x}")
    public static class MyRouter {
        volatile boolean wasInvoked = false;

        @RoutingPath(value="bar/{y}")
        public void myMethod(@PathParameter(value="x") Integer x, @PathParameter(value="y") String y) {
            this.wasInvoked = true;
            Assertions.assertThat((Integer)x).isEqualTo(111);
            Assertions.assertThat((String)y).isEqualTo("yyy");
        }
    }
}

