/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.NavigationState;

public class NavigationStateTest {
    @Test
    public void parse() {
        Assertions.assertThat((Object)NavigationState.parse(null)).isEqualTo((Object)new NavigationState("/", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"")).isEqualTo((Object)new NavigationState("/", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/")).isEqualTo((Object)new NavigationState("/", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"foo")).isEqualTo((Object)new NavigationState("/foo", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo")).isEqualTo((Object)new NavigationState("/foo", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/")).isEqualTo((Object)new NavigationState("/foo", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"foo/bar")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/bar")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/bar/")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/bar?")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of()));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/bar?x=1")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of("x", "1")));
        Assertions.assertThat((Object)NavigationState.parse((String)"/foo/bar/?x=1&y=2")).isEqualTo((Object)new NavigationState("/foo/bar", Map.of("x", "1", "y", "2")));
    }

    @Test
    public void toUrlEncodedString() {
        Assertions.assertThat((String)NavigationState.parse((String)"f\u00f6\u00f6/?\u00fear=ba\u2190").toString()).isEqualTo("/f\u00f6\u00f6?\u00fear=ba\u2190");
    }
}

