/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.navigation.Router;
import org.teamapps.ux.session.navigation.RoutingHandler;
import org.teamapps.ux.session.navigation.RoutingHandlerRegistration;
import org.teamapps.ux.session.navigation.RoutingUtil;

public class SubRouter
implements Router {
    private final String pathPrefix;
    private final SessionContext sessionContext;

    public SubRouter(String pathPrefix) {
        this(pathPrefix, SessionContext.current());
    }

    public SubRouter(String pathPrefix, SessionContext sessionContext) {
        this.pathPrefix = RoutingUtil.normalizePath(pathPrefix);
        this.sessionContext = sessionContext;
    }

    @Override
    public RoutingHandlerRegistration registerRoutingHandler(String pathTemplate, boolean exact, RoutingHandler handler, boolean applyImmediately) {
        return this.sessionContext.registerRoutingHandler(RoutingUtil.concatenatePaths(this.pathPrefix, pathTemplate), false, handler, applyImmediately);
    }

    @Override
    public Router createSubRouter(String relativePath) {
        return new SubRouter(RoutingUtil.concatenatePaths(this.pathPrefix, relativePath));
    }
}

