/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.dialogue;

import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;

public class FormDialogue
extends Window {
    public Event<Boolean> onResult = new Event();
    private ComboBox<BaseTemplateRecord<?>> comboBox;
    private Button<?> okButton;
    private Button<?> cancelButton;
    private Integer buttonLineIndex;
    private ResponsiveFormLayout formLayout;

    public static FormDialogue create(Icon icon, String title, String text) {
        return new FormDialogue(icon, title, text);
    }

    public FormDialogue(Icon icon, String title, String text) {
        this.setIcon(icon);
        this.setTitle(title);
        this.setWidth(550);
        this.setHeight(350);
        ResponsiveForm responsiveForm = new ResponsiveForm(0, 200, 0);
        this.formLayout = responsiveForm.addResponsiveFormLayout(450);
        this.formLayout.addSection().setDrawHeaderLine(false).setCollapsible(false).setMargin(new Spacing(10)).setGridGap(20);
        this.comboBox = new ComboBox();
        this.comboBox.setTemplate(BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.comboBox.setEditingMode(FieldEditingMode.READONLY);
        this.comboBox.setValue(new BaseTemplateRecord(icon, title, text));
        this.formLayout.addField(0, 0, "header", this.comboBox).setHorizontalAlignment(HorizontalElementAlignment.LEFT).setColSpan(3);
        this.setContent(responsiveForm);
    }

    public void addField(Icon icon, String caption, AbstractField<?> field) {
        this.formLayout.addLabelAndField((Icon)icon, (String)caption, field).field.setColSpan(2);
    }

    public void addOkCancelButtons(String okCaption, String cancelCaption) {
        this.addOkButton(okCaption);
        this.addCancelButton(cancelCaption);
    }

    public Button<?> addOkButton(String caption) {
        this.okButton = Button.create((Icon)MaterialIcon.CHECK, caption);
        this.okButton.onValueChanged.addListener(o -> {
            this.close(250);
            this.getSessionContext().flushCommands();
            this.onResult.fire(true);
        });
        this.formLayout.addField(this.getButtonLineIndex(), 1, "ok", this.okButton);
        return this.okButton;
    }

    public Button<?> addCancelButton(String caption) {
        this.cancelButton = Button.create((Icon)MaterialIcon.CANCEL, caption);
        this.cancelButton.onValueChanged.addListener(o -> {
            this.close(250);
            this.getSessionContext().flushCommands();
            this.onResult.fire(false);
        });
        this.formLayout.addField(this.getButtonLineIndex(), 2, "cancel", this.cancelButton);
        return this.cancelButton;
    }

    private int getButtonLineIndex() {
        if (this.buttonLineIndex == null) {
            this.buttonLineIndex = this.formLayout.getLastNonEmptyRowInSection() + 1;
        }
        return this.buttonLineIndex;
    }
}

