/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMap;
import org.teamapps.dto.UiMapArea;
import org.teamapps.dto.UiMapMarkerClientRecord;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.cache.ClientTemplateCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.map.Area;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.LocationChangedEventData;
import org.teamapps.ux.component.map.MapType;
import org.teamapps.ux.component.map.Marker;
import org.teamapps.ux.component.map.Polyline;
import org.teamapps.ux.component.template.Template;

public class MapView<RECORD>
extends AbstractComponent {
    public final Event<LocationChangedEventData> onLocationChanged = new Event();
    public final Event<Integer> onZoomLevelChanged = new Event();
    public final Event<Location> onMapClicked = new Event();
    public final Event<Marker<RECORD>> onMarkerClicked = new Event();
    private MapType mapType = MapType.MAP_BOX_STREETS_SATELLITE;
    private int zoomLevel = 5;
    private Location location = new Location(0.0, 0.0);
    private Map<String, Polyline> polylinesByClientId = new HashMap<String, Polyline>();
    private List<Marker<RECORD>> markers = new ArrayList<Marker<RECORD>>();
    private final ClientRecordCache<Marker<RECORD>, UiMapMarkerClientRecord> recordCache = new ClientRecordCache<Marker, UiMapMarkerClientRecord>(this::createUiRecord);
    private ClientTemplateCache<Marker<RECORD>> templateCache = new ClientTemplateCache(this::registerTemplate);
    private PropertyExtractor<RECORD> markerPropertyExtractor = new BeanPropertyExtractor();

    @Override
    public UiComponent createUiComponent() {
        UiMap uiMap = new UiMap(new HashMap());
        this.mapAbstractUiComponentProperties((UiComponent)uiMap);
        uiMap.setMapType(this.mapType.toUiMapType());
        uiMap.setZoomLevel(this.zoomLevel);
        HashMap uiPolylines = new HashMap();
        this.polylinesByClientId.forEach((id, polyline) -> uiPolylines.put(id, polyline.createUiMapPolyline()));
        uiMap.setPolylines(uiPolylines);
        if (this.location != null) {
            uiMap.setMapPosition(this.location.createUiLocation());
        }
        CacheManipulationHandle<List<UiMapMarkerClientRecord>> cacheResponse = this.recordCache.replaceRecords(this.markers);
        uiMap.setMarkers(cacheResponse.getResult());
        cacheResponse.commit();
        return uiMap;
    }

    private UiMapMarkerClientRecord createUiRecord(Marker<RECORD> marker) {
        UiMapMarkerClientRecord clientRecord = new UiMapMarkerClientRecord();
        clientRecord.setLocation(this.location.createUiLocation());
        ClientTemplateCache.TemplateWithClientId templateWithClientId = this.templateCache.getTemplateIdForRecord(marker);
        if (templateWithClientId.getTemplate() != null) {
            clientRecord.setTemplateId("" + templateWithClientId.getClientId());
            clientRecord.setValues(this.markerPropertyExtractor.getValues(marker.getData(), templateWithClientId.getTemplate().getDataKeys()));
        } else {
            clientRecord.setAsString("" + marker.getData());
        }
        return clientRecord;
    }

    private void registerTemplate(int id, Template template) {
        this.queueCommandIfRendered(() -> new UiMap.RegisterTemplateCommand(this.getId(), "" + id, template.createUiTemplate()));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MAP_MAP_CLICKED: {
                UiMap.MapClickedEvent mapClickedEvent = (UiMap.MapClickedEvent)event;
                this.onMapClicked.fire(new Location(mapClickedEvent.getLocation().getLatitude(), mapClickedEvent.getLocation().getLongitude()));
                break;
            }
            case UI_MAP_MARKER_CLICKED: {
                UiMap.MarkerClickedEvent markerClickedEvent = (UiMap.MarkerClickedEvent)event;
                Marker<RECORD> marker = this.recordCache.getRecordByClientId(markerClickedEvent.getMarkerId());
                this.onMarkerClicked.fire(marker);
                break;
            }
            case UI_MAP_ZOOM_LEVEL_CHANGED: {
                UiMap.ZoomLevelChangedEvent zoomEvent = (UiMap.ZoomLevelChangedEvent)event;
                this.zoomLevel = zoomEvent.getZoomLevel();
                this.onZoomLevelChanged.fire(this.zoomLevel);
                break;
            }
            case UI_MAP_LOCATION_CHANGED: {
                UiMap.LocationChangedEvent locationEvent = (UiMap.LocationChangedEvent)event;
                this.location = new Location(locationEvent.getCenter().getLatitude(), locationEvent.getCenter().getLongitude());
                UiMapArea displayedUiArea = locationEvent.getDisplayedArea();
                Area displayedArea = new Area(displayedUiArea.getMinLatitude(), displayedUiArea.getMaxLatitude(), displayedUiArea.getMinLongitude(), displayedUiArea.getMaxLongitude());
                this.onLocationChanged.fire(new LocationChangedEventData(this.location, displayedArea));
                break;
            }
        }
    }

    public Polyline addPolyLine(Polyline polyline) {
        polyline.setListener((polyline1, newPoints) -> this.queueCommandIfRendered(() -> new UiMap.AddPolylinePointsCommand(this.getId(), polyline.getClientId(), newPoints.stream().map(Location::createUiLocation).collect(Collectors.toList()))));
        this.polylinesByClientId.put(polyline.getClientId(), polyline);
        this.queueCommandIfRendered(() -> new UiMap.AddPolylineCommand(this.getId(), polyline.getClientId(), polyline.createUiMapPolyline()));
        return polyline;
    }

    public void removePolyline(Polyline polyline) {
        this.queueCommandIfRendered(() -> new UiMap.RemovePolylineCommand(this.getId(), polyline.getClientId()));
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public void setMapType(MapType mapType) {
        this.mapType = mapType;
        this.queueCommandIfRendered(() -> new UiMap.SetMapTypeCommand(this.getId(), this.mapType.toUiMapType()));
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.queueCommandIfRendered(() -> new UiMap.SetZoomLevelCommand(this.getId(), zoomLevel));
    }

    public void setLocation(Location location) {
        this.location = location;
        this.queueCommandIfRendered(() -> new UiMap.SetLocationCommand(this.getId(), location.createUiLocation()));
    }

    public void setLocation(double latitude, double longitude) {
        this.setLocation(new Location(latitude, longitude));
    }

    public void setLatitude(double latitude) {
        this.setLocation(new Location(latitude, this.location.getLongitude()));
    }

    public void setLongitude(double longitude) {
        this.setLocation(new Location(this.location.getLatitude(), longitude));
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public Location getLocation() {
        return this.location;
    }

    public void addMarker(Marker<RECORD> marker) {
        this.markers.add(marker);
        CacheManipulationHandle<UiMapMarkerClientRecord> cacheResponse = this.recordCache.addRecord(marker);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiMap.AddMarkerCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
        } else {
            cacheResponse.commit();
        }
    }

    public void removeMarker(Marker<RECORD> marker) {
        boolean removed = this.markers.remove(marker);
        if (removed) {
            CacheManipulationHandle<Integer> cacheResponse = this.recordCache.removeRecord(marker);
            if (this.isRendered()) {
                this.getSessionContext().queueCommand(new UiMap.RemoveMarkerCommand(this.getId(), cacheResponse.getResult().intValue()), aVoid -> cacheResponse.commit());
            } else {
                cacheResponse.commit();
            }
        }
    }

    public void setDefaultMarkerTemplate(Template defaultTemplate) {
        this.templateCache.setDefaultTemplate(defaultTemplate);
    }

    public void setMarkerTemplateDecider(TemplateDecider<Marker<RECORD>> templateDecider) {
        this.templateCache.setTemplateDecider(templateDecider);
    }

    public PropertyExtractor<RECORD> getMarkerPropertyExtractor() {
        return this.markerPropertyExtractor;
    }

    public void setMarkerPropertyExtractor(PropertyExtractor<RECORD> markerPropertyExtractor) {
        this.markerPropertyExtractor = markerPropertyExtractor;
    }

    @Override
    protected void doDestroy() {
    }
}

