/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.ux.resource.Resource;

public class FileResource
implements Resource {
    private static final Map<String, String> MIMETYPES_BY_FILE_EXTENSION;
    private File file;

    public FileResource(File file) {
        this.file = file;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    @Override
    public Date getExpires() {
        return new Date(System.currentTimeMillis() + 604800000L);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getMimeType() {
        String fileType = this.getFileType();
        if (fileType == null) {
            return "application/octet-stream";
        }
        return MIMETYPES_BY_FILE_EXTENSION.getOrDefault(fileType, "application/octet-stream");
    }

    private String getFileType() {
        int pos = this.file.getName().lastIndexOf(46);
        if (pos <= 0 || pos >= this.file.getName().length() - 1) {
            return null;
        }
        return this.file.getName().substring(pos + 1).toLowerCase();
    }

    static {
        try {
            MIMETYPES_BY_FILE_EXTENSION = (Map)new ObjectMapper().readValue(FileResource.class.getResource("mimetypes-by-file-extension.json"), HashMap.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

