/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import java.util.List;
import java.util.UUID;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.event.Event;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutSplitPane;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public abstract class WorkSpaceLayoutItem {
    public final Event<Void> onRemoved = new Event();
    private final String id;
    private final WorkSpaceLayout workSpaceLayout;
    private WorkSpaceLayoutSplitPane parent;

    public WorkSpaceLayoutItem(String id, WorkSpaceLayout workSpaceLayout) {
        this.id = id;
        this.workSpaceLayout = workSpaceLayout;
    }

    public WorkSpaceLayoutItem(WorkSpaceLayout workSpaceLayout) {
        this(UUID.randomUUID().toString(), workSpaceLayout);
    }

    public String getId() {
        return this.id;
    }

    public abstract UiWorkSpaceLayoutItem createUiItem();

    public abstract LayoutItemDefinition createLayoutDefinitionItem();

    protected WorkSpaceLayout getWorkSpaceLayout() {
        return this.workSpaceLayout;
    }

    public WorkSpaceLayoutSplitPane getParent() {
        return this.parent;
    }

    public void setParent(WorkSpaceLayoutSplitPane parent) {
        this.parent = parent;
    }

    public abstract List<WorkSpaceLayoutView> getAllViews();

    public abstract List<WorkSpaceLayoutItem> getSelfAndAncestors();

    void handleRemoved() {
        this.callHandleRemovedOnChildren();
        this.onRemoved.fire(null);
    }

    protected abstract void callHandleRemovedOnChildren();
}

