/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.InputStream;
import java.util.Objects;
import org.teamapps.ux.resource.Resource;

public class ClassPathResource
implements Resource {
    private final String resourceName;
    private final String name;
    private final ClassLoader classLoader;
    private final String mimeType;
    private long length = -1L;

    public ClassPathResource(String resourceName) {
        this(resourceName, null, null);
    }

    public ClassPathResource(String resourceName, String mimeType) {
        this(resourceName, null, mimeType);
    }

    public ClassPathResource(String resourceName, ClassLoader classLoader) {
        this(resourceName, classLoader, null);
    }

    public ClassPathResource(String resourceName, ClassLoader classLoader, String mimeType) {
        this.resourceName = resourceName;
        this.name = resourceName.contains("/") ? resourceName.substring(resourceName.lastIndexOf(47) + 1) : resourceName;
        this.classLoader = classLoader;
        this.mimeType = mimeType;
    }

    @Override
    public InputStream getInputStream() {
        InputStream is;
        if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(this.resourceName);
        } else {
            is = this.getClass().getResourceAsStream(this.resourceName);
            if (is == null) {
                is = ClassLoader.getSystemResourceAsStream(this.resourceName);
            }
        }
        return is;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public long getLength() {
        if (this.length < 0L) {
            this.length = Resource.super.getLength();
        }
        return this.length;
    }

    public String toString() {
        return "ClassPathResource{resourceName='" + this.resourceName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.length == that.length && Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.name, that.name) && Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.mimeType, that.mimeType);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.name, this.classLoader, this.mimeType, this.length);
    }
}

