/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.ux.session.navigation.RoutingUtil;

public class NavigationState {
    private static final NavigationState EMPTY = new NavigationState("/", Map.of());
    private static final Pattern RELATIVE_URL_PATTERN = Pattern.compile("(.*?)?(\\?.*?)?(#.*)?");
    private final String relativePath;
    private final Map<String, String> queryParams;

    public static NavigationState create() {
        return EMPTY;
    }

    public static NavigationState parse(String relativeUrl) {
        if (StringUtils.isBlank((CharSequence)relativeUrl)) {
            return new NavigationState("/", Map.of());
        }
        Matcher matcher = RELATIVE_URL_PATTERN.matcher(relativeUrl);
        if (matcher.matches()) {
            String path = matcher.group(1);
            path = RoutingUtil.normalizePath(path);
            Map<String, String> queryParams = RoutingUtil.parseQueryParams(matcher.group(2));
            return new NavigationState(path, queryParams);
        }
        throw new IllegalArgumentException("Unparsable relative URL: " + relativeUrl);
    }

    public NavigationState(String relativePath, Map<String, String> queryParams) {
        this.relativePath = relativePath;
        this.queryParams = queryParams;
    }

    public NavigationState withPrefix(String pathPrefix) {
        return new NavigationState(RoutingUtil.concatenatePaths(pathPrefix, this.relativePath), this.queryParams);
    }

    public NavigationState withPath(String path) {
        return new NavigationState(path, this.queryParams);
    }

    public NavigationState withQueryParam(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        HashMap<String, String> newQueryParams = new HashMap<String, String>(this.queryParams);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            newQueryParams.put(key, value);
        } else {
            newQueryParams.remove(key);
        }
        return new NavigationState(this.relativePath, newQueryParams);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String toString() {
        return this.relativePath + (String)(!this.queryParams.isEmpty() ? "?" + this.queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&")) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigationState that = (NavigationState)o;
        return Objects.equals(this.relativePath, that.relativePath) && Objects.equals(this.queryParams, that.queryParams);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath, this.queryParams);
    }
}

