/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.gridtemplate;

import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.dto.UiImageElement;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.ImageSizing;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.template.gridtemplate.AbstractTemplateElement;

public class ImageElement
extends AbstractTemplateElement {
    protected int width;
    protected int height;
    protected Border border;
    protected Spacing padding;
    protected Shadow shadow;
    protected ImageSizing imageSizing = ImageSizing.COVER;

    public ImageElement(String propertyName, int width, int height) {
        super(propertyName);
        this.width = width;
        this.height = height;
    }

    public ImageElement(String propertyName, int row, int column, int width, int height) {
        super(propertyName, row, column);
        this.width = width;
        this.height = height;
    }

    public ImageElement(String propertyName, int row, int column, int rowSpan, int colSpan, int width, int height) {
        super(propertyName, row, column, rowSpan, colSpan);
        this.width = width;
        this.height = height;
    }

    public ImageElement(String propertyName, int row, int column, int rowSpan, int colSpan, HorizontalElementAlignment horizontalAlignment, VerticalElementAlignment verticalAlignment, int width, int height) {
        super(propertyName, row, column, rowSpan, colSpan, horizontalAlignment, verticalAlignment);
        this.width = width;
        this.height = height;
    }

    public ImageElement(String propertyName, int width, int height, Border border, Spacing padding, Shadow shadow) {
        super(propertyName);
        this.width = width;
        this.height = height;
        this.border = border;
        this.padding = padding;
        this.shadow = shadow;
    }

    public ImageElement(String propertyName, int row, int column, int width, int height, Border border, Spacing padding, Shadow shadow) {
        super(propertyName, row, column);
        this.width = width;
        this.height = height;
        this.border = border;
        this.padding = padding;
        this.shadow = shadow;
    }

    public ImageElement(String propertyName, int row, int column, int rowSpan, int colSpan, int width, int height, Border border, Spacing padding, Shadow shadow) {
        super(propertyName, row, column, rowSpan, colSpan);
        this.width = width;
        this.height = height;
        this.border = border;
        this.padding = padding;
        this.shadow = shadow;
    }

    public ImageElement setWidth(int width) {
        this.width = width;
        return this;
    }

    public ImageElement setHeight(int height) {
        this.height = height;
        return this;
    }

    public ImageElement setBorder(Border border) {
        this.border = border;
        return this;
    }

    public ImageElement setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    public ImageElement setShadow(Shadow shadow) {
        this.shadow = shadow;
        return this;
    }

    public ImageElement setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public AbstractTemplateElement setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public AbstractTemplateElement setMargin(Spacing margin) {
        this.margin = margin;
        return this;
    }

    @Override
    public AbstractUiTemplateElement createUiTemplateElement() {
        UiImageElement uiImageElement = new UiImageElement(this.propertyName, this.row, this.column, this.width, this.height);
        this.mapAbstractTemplateElementAttributesToUiElement((AbstractUiTemplateElement)uiImageElement);
        uiImageElement.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiImageElement.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        uiImageElement.setShadow(this.shadow != null ? this.shadow.createUiShadow() : null);
        uiImageElement.setImageSizing(this.imageSizing.toUiImageSizing());
        return uiImageElement;
    }

    public ImageElement setRow(int row) {
        this.row = row;
        return this;
    }

    public ImageElement setColumn(int column) {
        this.column = column;
        return this;
    }

    public ImageElement setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public ImageElement setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Border getBorder() {
        return this.border;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public ImageSizing getImageSizing() {
        return this.imageSizing;
    }

    public ImageElement setImageSizing(ImageSizing imageSizing) {
        this.imageSizing = imageSizing;
        return this;
    }
}

