/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.glassfish.jersey.uri.UriTemplate;
import org.teamapps.ux.session.navigation.Location;
import org.teamapps.ux.session.navigation.Router;
import org.teamapps.ux.session.navigation.RoutingHandler;
import org.teamapps.ux.session.navigation.RoutingHandlerRegistration;
import org.teamapps.ux.session.navigation.RoutingUtil;
import org.teamapps.ux.session.navigation.SubRouter;

public class BaseRouting
implements Router {
    static final String PATH_REMAINDER_VARNAME = "_remainder";
    static final String PATH_REMAINDER_SUFFIX = "{_remainder:(/.*)?}";
    private final String pathPrefix;
    private final ParamConverterProvider paramConverterProvider;
    private final List<UriTemplateAndHandler> handlers = new CopyOnWriteArrayList<UriTemplateAndHandler>();
    private Location currentLocation;

    public BaseRouting(String pathPrefix, ParamConverterProvider paramConverterProvider, Location location) {
        this.pathPrefix = RoutingUtil.normalizePath(pathPrefix);
        this.paramConverterProvider = paramConverterProvider;
        this.currentLocation = location;
    }

    @Override
    public RoutingHandlerRegistration registerRoutingHandler(String pathTemplate, boolean exact, RoutingHandler handler, boolean applyImmediately) {
        final UriTemplate uriTemplate = new UriTemplate(RoutingUtil.concatenatePaths(this.pathPrefix, pathTemplate) + (exact ? "" : PATH_REMAINDER_SUFFIX));
        final UriTemplateAndHandler templateAndRouter = new UriTemplateAndHandler(uriTemplate, handler);
        this.handlers.add(templateAndRouter);
        if (applyImmediately) {
            this.routeInternal(this.currentLocation, List.of(templateAndRouter));
        }
        return new RoutingHandlerRegistration(){

            @Override
            public String createPath(Map<String, String> params) {
                return uriTemplate.createURI(params);
            }

            @Override
            public void dispose() {
                BaseRouting.this.handlers.remove(templateAndRouter);
            }
        };
    }

    @Override
    public Router createSubRouter(String relativePath) {
        return new SubRouter(RoutingUtil.concatenatePaths(this.pathPrefix, relativePath));
    }

    public void route(Location location) {
        this.currentLocation = location;
        this.routeInternal(location, this.handlers);
    }

    private void routeInternal(Location location, List<UriTemplateAndHandler> handlers) {
        String relativePath = RoutingUtil.normalizePath(location.getPathname());
        Map<String, String> queryParams = RoutingUtil.parseQueryParams(location.getSearch());
        for (UriTemplateAndHandler uriTemplateAndHandler : handlers) {
            HashMap<String, String> pathParams = new HashMap<String, String>();
            boolean matches = uriTemplateAndHandler.getUriTemplate().match((CharSequence)relativePath, pathParams);
            if (!matches) continue;
            uriTemplateAndHandler.getHandler().handle(relativePath, pathParams, queryParams);
        }
    }

    public ParamConverterProvider getParamConverterProvider() {
        return this.paramConverterProvider;
    }

    private static class UriTemplateAndHandler {
        private final UriTemplate uriTemplate;
        private final RoutingHandler handler;

        public UriTemplateAndHandler(UriTemplate uriTemplate, RoutingHandler handler) {
            this.uriTemplate = uriTemplate;
            this.handler = handler;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }

        public RoutingHandler getHandler() {
            return this.handler;
        }
    }
}

