/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.Route;

public class NavigationStateTest {
    @Test
    public void parse() {
        Assertions.assertThat((Object)Route.parse(null)).isEqualTo((Object)new Route("/", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"")).isEqualTo((Object)new Route("/", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/")).isEqualTo((Object)new Route("/", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"foo")).isEqualTo((Object)new Route("/foo", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo")).isEqualTo((Object)new Route("/foo", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo/")).isEqualTo((Object)new Route("/foo", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"foo/bar")).isEqualTo((Object)new Route("/foo/bar", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo/bar")).isEqualTo((Object)new Route("/foo/bar", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo/bar/")).isEqualTo((Object)new Route("/foo/bar", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo/bar?")).isEqualTo((Object)new Route("/foo/bar", Map.of()));
        Assertions.assertThat((Object)Route.parse((String)"/foo/bar?x=1")).isEqualTo((Object)new Route("/foo/bar", Map.of("x", "1")));
        Assertions.assertThat((Object)Route.parse((String)"/foo/bar/?x=1&y=2")).isEqualTo((Object)new Route("/foo/bar", Map.of("x", "1", "y", "2")));
    }

    @Test
    public void toUrlEncodedString() {
        Assertions.assertThat((String)Route.parse((String)"f\u00f6\u00f6/?\u00fear=ba\u2190").toString()).isEqualTo("/f\u00f6\u00f6?\u00fear=ba\u2190");
    }
}

