/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.popup;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiPopup;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;

public class Popup
extends AbstractComponent {
    private Component contentComponent;
    private int x;
    private int y;
    private int width;
    private int height;
    private Color backgroundColor;
    private boolean modal = false;
    private Color dimmingColor = new RgbaColor(0, 0, 0, 0.2f);
    private boolean closeOnEscape;
    private boolean closeOnClickOutside;

    public Popup(Component contentComponent) {
        this.contentComponent = contentComponent;
    }

    @Override
    public UiComponent createUiComponent() {
        UiPopup ui = new UiPopup();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setContentComponent(this.contentComponent.createUiReference());
        ui.setX(this.x);
        ui.setY(this.y);
        ui.setWidth(this.width);
        ui.setHeight(this.height);
        ui.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        ui.setModal(this.modal);
        ui.setDimmingColor(this.dimmingColor != null ? this.dimmingColor.toHtmlColorString() : null);
        ui.setCloseOnEscape(this.closeOnEscape);
        ui.setCloseOnClickOutside(this.closeOnClickOutside);
        return ui;
    }

    public Component getContentComponent() {
        return this.contentComponent;
    }

    public void setContentComponent(Component contentComponent) {
        this.contentComponent = contentComponent;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        this.queueCommandIfRendered(() -> new UiPopup.SetPositionCommand(this.getId(), x, this.y));
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.queueCommandIfRendered(() -> new UiPopup.SetPositionCommand(this.getId(), this.x, y));
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.queueCommandIfRendered(() -> new UiPopup.SetPositionCommand(this.getId(), x, y));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.queueCommandIfRendered(() -> new UiPopup.SetDimensionsCommand(this.getId(), width, this.height));
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiPopup.SetDimensionsCommand(this.getId(), this.width, height));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiPopup.SetBackgroundColorCommand(this.getId(), backgroundColor != null ? backgroundColor.toHtmlColorString() : null));
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public Color getDimmingColor() {
        return this.dimmingColor;
    }

    public void setDimmingColor(Color dimmingColor) {
        this.dimmingColor = dimmingColor;
        this.queueCommandIfRendered(() -> new UiPopup.SetDimmingColorCommand(this.getId(), dimmingColor != null ? dimmingColor.toHtmlColorString() : null));
    }

    public boolean isCloseOnEscape() {
        return this.closeOnEscape;
    }

    public void setCloseOnEscape(boolean closeOnEscape) {
        this.closeOnEscape = closeOnEscape;
    }

    public boolean isCloseOnClickOutside() {
        return this.closeOnClickOutside;
    }

    public void setCloseOnClickOutside(boolean closeOnClickOutside) {
        this.closeOnClickOutside = closeOnClickOutside;
    }

    public void close() {
        this.queueCommandIfRendered(() -> new UiPopup.CloseCommand(this.getId()));
    }
}

