/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.dto.UiLocation;
import org.teamapps.ux.session.navigation.RoutingUtil;

public class Location {
    private final String href;
    private final String origin;
    private final String protocol;
    private final String host;
    private final String hostname;
    private final Integer port;
    private final String pathname;
    private final String search;
    private final String hash;

    public Location(String protocol, String hostname, Integer port, String pathname, String search, String hash) {
        if (!((String)protocol).endsWith(":")) {
            protocol = (String)protocol + ":";
        }
        this.href = (String)protocol + "//" + hostname + ":" + port + RoutingUtil.withSingleLeadingSlash(pathname) + search + hash;
        this.origin = (String)protocol + "//" + hostname + ":" + port;
        this.protocol = protocol;
        this.host = hostname + ":" + port;
        this.hostname = hostname;
        this.port = port;
        this.pathname = pathname;
        this.search = search;
        this.hash = hash;
    }

    public Location(String href, String origin, String protocol, String host, String hostname, Integer port, String pathname, String search, String hash) {
        this.href = href;
        this.origin = origin;
        this.protocol = protocol;
        this.host = host;
        this.hostname = hostname;
        this.port = port;
        this.pathname = pathname;
        this.search = search;
        this.hash = hash;
    }

    public static Location parse(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return new Location(url.toString(), url.getProtocol() + "://" + url.getHost() + (String)(url.getPort() > 0 ? ":" + url.getPort() : ""), url.getProtocol(), url.getHost() + (String)(url.getPort() > 0 ? ":" + url.getPort() : ""), url.getHost(), url.getPort() > 0 ? Integer.valueOf(url.getPort()) : null, StringUtils.isNotBlank((CharSequence)url.getPath()) ? url.getPath() : "/", (String)(StringUtils.isNotBlank((CharSequence)url.getQuery()) ? "?" + url.getQuery() : ""), (String)(StringUtils.isNotBlank((CharSequence)url.getRef()) ? "#" + url.getRef() : ""));
    }

    public static Location fromUiLocation(UiLocation uiLocation) {
        if (uiLocation.getPathname().length() > 0 && !uiLocation.getPathname().startsWith("/")) {
            throw new IllegalArgumentException("Non-empty pathname must always start with a slash!");
        }
        return new Location(Objects.requireNonNull(uiLocation.getHref()), Objects.requireNonNull(uiLocation.getOrigin()), Objects.requireNonNull(uiLocation.getProtocol()), Objects.requireNonNull(uiLocation.getHost()), Objects.requireNonNull(uiLocation.getHostname()), uiLocation.getPort(), uiLocation.getPathname() != null ? uiLocation.getPathname() : "", uiLocation.getSearch() != null ? uiLocation.getSearch() : "", uiLocation.getHash() != null ? uiLocation.getHash() : "");
    }

    public String getHref() {
        return this.href;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getSearch() {
        return this.search;
    }

    public String getHash() {
        return this.hash;
    }

    public Location withPathNameAndQueryParams(String pathNameAndQueryParams) {
        String search;
        String pathName;
        int questionMarkIndex = pathNameAndQueryParams.indexOf("?");
        if (questionMarkIndex >= 0) {
            pathName = pathNameAndQueryParams.substring(0, questionMarkIndex);
            search = pathNameAndQueryParams.substring(questionMarkIndex + 1);
        } else {
            pathName = pathNameAndQueryParams;
            search = "";
        }
        return new Location(this.protocol, this.hostname, this.port, pathName, search, this.hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Objects.equals(this.href, location.href) && Objects.equals(this.origin, location.origin) && Objects.equals(this.protocol, location.protocol) && Objects.equals(this.host, location.host) && Objects.equals(this.hostname, location.hostname) && Objects.equals(this.port, location.port) && Objects.equals(this.pathname, location.pathname) && Objects.equals(this.search, location.search) && Objects.equals(this.hash, location.hash);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.origin, this.protocol, this.host, this.hostname, this.port, this.pathname, this.search, this.hash);
    }
}

