/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class JacksonTypeInfoTest {
    @Test
    public void testTypeInfoOnObjectReference() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)new ObjectReferencePojo(new Pojo()));
        System.out.println(json);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"_attribute_type\":\"org.teamapps.json.JacksonTypeInfoTest$Pojo\""});
    }

    @Test
    public void testClassLevelTypeInfo() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)new ClassLevelTypeInfoPojo());
        System.out.println(json);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"_class_type\":\"org.teamapps.json.JacksonTypeInfoTest$ClassLevelTypeInfoPojo\""});
    }

    @Test
    public void testObjectListTypeInfo() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)new ClassLevelTypeInfoPojo());
        System.out.println(json);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"_class_type\":\"org.teamapps.json.JacksonTypeInfoTest$ClassLevelTypeInfoPojo\""});
    }

    @Test
    public void attributeLevelWins() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)new ObjectListReferencePojo(Arrays.asList(new Pojo(), new Pojo())));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"x\":[{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoTest$Pojo\",\"x\":123},{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoTest$Pojo\",\"x\":123}]}");
    }

    @Test
    public void testConcreteClassReferenceToAnnotatedObject() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)new ConcreteReferencePojo(new ClassLevelTypeInfoPojo()));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"x\":{\"_class_type\":\"org.teamapps.json.JacksonTypeInfoTest$ClassLevelTypeInfoPojo\",\"x\":123}}");
    }

    public static class Pojo {
        int x = 123;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="_class_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ClassLevelTypeInfoPojo {
        int x = 123;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class ConcreteReferencePojo {
        public ClassLevelTypeInfoPojo x;

        public ConcreteReferencePojo() {
        }

        public ConcreteReferencePojo(ClassLevelTypeInfoPojo x) {
            this.x = x;
        }

        public ClassLevelTypeInfoPojo getX() {
            return this.x;
        }

        public void setX(ClassLevelTypeInfoPojo x) {
            this.x = x;
        }
    }

    public static class ObjectListReferencePojo {
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="_list_attribute_type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public List x;

        public ObjectListReferencePojo() {
        }

        public ObjectListReferencePojo(List x) {
            this.x = x;
        }

        public List getX() {
            return this.x;
        }

        public void setX(List x) {
            this.x = x;
        }
    }

    public static class ObjectReferencePojo {
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="_attribute_type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Object x;

        public ObjectReferencePojo() {
        }

        public ObjectReferencePojo(Object x) {
            this.x = x;
        }

        public Object getX() {
            return this.x;
        }

        public void setX(Object x) {
            this.x = x;
        }
    }
}

