/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc.apiclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.ux.component.webrtc.apiclient.MediaKind;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3RestClient;
import org.teamapps.ux.component.webrtc.apiclient.StreamData;
import org.teamapps.ux.component.webrtc.apiclient.StreamFileRequestBuilder;

public class MediaSoupV3ResClientTest {
    public static void main(String[] args) throws InterruptedException, ExecutionException, TimeoutException {
        MediaSoupV3RestClient client = new MediaSoupV3RestClient("http://127.0.0.1:8723", "asdf");
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        futures.add(client.startRecording(0, "myStream", Set.of(MediaKind.AUDIO, MediaKind.VIDEO)).thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.startRecording(0, "myStream").thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.stopRecording(0, "myStream").thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.getWorkerLoad(0).thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.getNumberOfWorkers().thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.getRecordedStreamUuids().thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.getStreamRecordingsForUuid("myStream").thenAccept(r -> System.out.println("Response: " + r)));
        futures.add(client.startFileStreaming(1, new StreamFileRequestBuilder("myFileStream", Set.of(MediaKind.AUDIO, MediaKind.VIDEO), "http://localhost:8081/resources/asdf.mp4", false).build()));
        futures.add(client.stopFileStreaming(1, "myFileStream"));
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).get(10L, TimeUnit.SECONDS);
        System.exit(0);
    }

    @Test
    public void testSerialization() throws Exception {
        Assert.assertEquals((Object)"{\"stream\":\"x\"}", (Object)new ObjectMapper().writeValueAsString((Object)new StreamData("x")));
    }
}

