/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value;

import java.util.Objects;
import org.teamapps.data.value.SortDirection;

public class Sorting {
    private final String fieldName;
    private final SortDirection sortDirection;

    public Sorting(String fieldName, SortDirection sortDirection) {
        Objects.requireNonNull(fieldName, "fieldName must not be null!");
        Objects.requireNonNull(fieldName, "sortDirection must not be null!");
        this.fieldName = fieldName;
        this.sortDirection = sortDirection;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public boolean isSorted() {
        return this.sortDirection != null && this.fieldName != null && !this.fieldName.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sorting sorting1 = (Sorting)o;
        if (this.fieldName != null ? !this.fieldName.equals(sorting1.fieldName) : sorting1.fieldName != null) {
            return false;
        }
        return this.sortDirection == sorting1.sortDirection;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.sortDirection != null ? this.sortDirection.hashCode() : 0);
        return result;
    }
}

