/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import org.junit.Test;

public class JacksonCustomDeserializerTest {
    @Test
    public void test() throws Exception {
        Object o = new ObjectMapper().readValue("{\"x\":[{\"x\":123}]}", ObjectReferencePojo.class);
        System.out.println(o);
    }

    public static class CustomDeserializer
    extends StdDeserializer<Object> {
        protected CustomDeserializer() {
            super(Object.class);
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (p.getCurrentToken() == JsonToken.START_ARRAY) {
                return ctxt.readValue(p, List.class);
            }
            return null;
        }
    }

    public static class ObjectReferencePojo {
        @JsonDeserialize(using=CustomDeserializer.class)
        public Object x;

        public ObjectReferencePojo() {
        }

        public ObjectReferencePojo(Object x) {
            this.x = x;
        }

        public Object getX() {
            return this.x;
        }

        public void setX(Object x) {
            this.x = x;
        }
    }
}

