/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util.threading;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teamapps.util.threading.CompletableFutureChainSequentialExecutorFactory;

public class CompletableFutureChainSequentialExecutorFactoryTest {
    @Test
    public void executionOrderOneKey() throws Exception {
        int numberOfExecutions = 1000;
        CompletableFutureChainSequentialExecutorFactory executorFactory = new CompletableFutureChainSequentialExecutorFactory(2);
        IntArrayList executionOrderCheckingList = new IntArrayList();
        Future<Boolean> lastFuture = null;
        ExecutorService executor = executorFactory.createExecutor();
        int i = 0;
        while (i < numberOfExecutions) {
            int iFinal = i++;
            lastFuture = executor.submit(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderOneKey$0((IntList)executionOrderCheckingList, iFinal));
        }
        lastFuture.get();
        this.checkIntListContents((IntList)executionOrderCheckingList, numberOfExecutions);
    }

    @Test
    public void executionOrderMultipleKey() throws Exception {
        int numberOfExecutions = 1000;
        CompletableFutureChainSequentialExecutorFactory executor = new CompletableFutureChainSequentialExecutorFactory(2);
        IntArrayList executionOrderCheckingList1 = new IntArrayList();
        IntArrayList executionOrderCheckingList2 = new IntArrayList();
        IntArrayList executionOrderCheckingList3 = new IntArrayList();
        CompletableFuture<Boolean> lastFuture1 = null;
        CompletableFuture<Boolean> lastFuture2 = null;
        CompletableFuture<Boolean> lastFuture3 = null;
        ExecutorService executor1 = executor.createExecutor();
        ExecutorService executor2 = executor.createExecutor();
        ExecutorService executor3 = executor.createExecutor();
        int i = 0;
        while (i < numberOfExecutions) {
            int iFinal = i++;
            lastFuture1 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$1((IntList)executionOrderCheckingList1, iFinal), executor1);
            lastFuture2 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$2((IntList)executionOrderCheckingList2, iFinal), executor2);
            lastFuture3 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$3((IntList)executionOrderCheckingList3, iFinal), executor3);
        }
        CompletableFuture.allOf(new CompletableFuture[]{lastFuture1.thenRun(() -> this.lambda$executionOrderMultipleKey$4((IntList)executionOrderCheckingList1, numberOfExecutions)), lastFuture2.thenRun(() -> this.lambda$executionOrderMultipleKey$5((IntList)executionOrderCheckingList2, numberOfExecutions)), lastFuture3.thenRun(() -> this.lambda$executionOrderMultipleKey$6((IntList)executionOrderCheckingList3, numberOfExecutions))}).get();
    }

    @Test
    public void executionContinuesAfterException() throws Exception {
        CompletableFutureChainSequentialExecutorFactory executor = new CompletableFutureChainSequentialExecutorFactory(2);
        executor.createExecutor().submit(() -> {
            throw new RuntimeException();
        });
        boolean[] secondWasExecuted = new boolean[]{false};
        executor.createExecutor().submit(() -> {
            secondWasExecuted[0] = true;
        }).get();
        Assert.assertTrue((boolean)secondWasExecuted[0]);
    }

    @Test
    @Ignore
    public void performance() throws InterruptedException, ExecutionException {
        CompletableFutureChainSequentialExecutorFactory executorFactory = new CompletableFutureChainSequentialExecutorFactory(20);
        long now = System.currentTimeMillis();
        long in5seconds = now + 3000L;
        AtomicBoolean shutdown = new AtomicBoolean(false);
        AtomicBoolean done = new AtomicBoolean(false);
        Runnable task = () -> {
            while (System.currentTimeMillis() < in5seconds) {
            }
            if (done.get()) {
                System.err.println("AFTER DONE!");
            }
        };
        List executors = IntStream.range(0, 10).mapToObj(i -> executorFactory.createExecutor()).collect(Collectors.toList());
        ExecutorService x = Executors.newFixedThreadPool(20);
        for (int i2 = 0; i2 < 1000000; ++i2) {
            x.submit(() -> {
                ((ExecutorService)executors.get(ThreadLocalRandom.current().nextInt(0, 10))).submit(task);
                if (shutdown.get()) {
                    System.err.println("After shutdown??");
                }
            });
        }
        x.shutdown();
        x.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        System.out.println("Shutdown = true");
        shutdown.set(true);
        CompletableFuture[] completionFutures = (CompletableFuture[])IntStream.range(0, 10).mapToObj(i -> ((ExecutorService)executors.get(i)).submit(task)).toArray(CompletableFuture[]::new);
        ((CompletableFuture)CompletableFuture.allOf(completionFutures).thenRun(() -> {
            done.set(true);
            System.err.println("Done after " + (System.currentTimeMillis() - in5seconds) + "ms");
        })).get();
        Thread.sleep(1000L);
    }

    private void checkIntListContents(IntList executionOrderCheckingList, int rangeMax) {
        Assertions.assertThat((int[])executionOrderCheckingList.toIntArray()).containsExactly(IntStream.range(0, rangeMax).toArray());
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$6(IntList executionOrderCheckingList3, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList3, numberOfExecutions);
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$5(IntList executionOrderCheckingList2, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList2, numberOfExecutions);
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$4(IntList executionOrderCheckingList1, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList1, numberOfExecutions);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$3(IntList executionOrderCheckingList3, int iFinal) {
        return executionOrderCheckingList3.add(iFinal);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$2(IntList executionOrderCheckingList2, int iFinal) {
        return executionOrderCheckingList2.add(iFinal);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$1(IntList executionOrderCheckingList1, int iFinal) {
        return executionOrderCheckingList1.add(iFinal);
    }

    private static /* synthetic */ Boolean lambda$executionOrderOneKey$0(IntList executionOrderCheckingList, int iFinal) throws Exception {
        return executionOrderCheckingList.add(iFinal);
    }
}

