/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coercor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coercor.class);

    public static <T> T coerce(Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (Coercor.isNumberType(targetType) && value instanceof Number) {
            if (targetType == Byte.class || targetType == Byte.TYPE) {
                return (T)Byte.valueOf(((Number)value).byteValue());
            }
            if (targetType == Short.class || targetType == Short.TYPE) {
                return (T)Short.valueOf(((Number)value).shortValue());
            }
            if (targetType == Integer.class || targetType == Integer.TYPE) {
                return (T)Integer.valueOf(((Number)value).intValue());
            }
            if (targetType == Long.class || targetType == Long.TYPE) {
                return (T)Long.valueOf(((Number)value).longValue());
            }
            if (targetType == Float.class || targetType == Float.TYPE) {
                return (T)Float.valueOf(((Number)value).floatValue());
            }
            if (targetType == Double.class || targetType == Double.TYPE) {
                return (T)Double.valueOf(((Number)value).doubleValue());
            }
        } else if (targetType == String.class) {
            return (T)value.toString();
        }
        return (T)value;
    }

    private static <T> boolean isNumberType(Class<T> targetType) {
        return Number.class.isAssignableFrom(targetType) || targetType == Byte.TYPE || targetType == Short.TYPE || targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
    }
}

