/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.BeanPropertyInjector;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemView;
import org.teamapps.dto.UiRefreshableTableConfigUpdate;
import org.teamapps.dto.UiTable;
import org.teamapps.dto.UiTableClientRecord;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.cache.record.DuplicateEntriesException;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteListComponent;
import org.teamapps.ux.component.infiniteitemview.RecordsChangedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsRemovedEvent;
import org.teamapps.ux.component.table.CellClickedEvent;
import org.teamapps.ux.component.table.CellEditingStartedEvent;
import org.teamapps.ux.component.table.CellEditingStoppedEvent;
import org.teamapps.ux.component.table.ColumnOrderChangeEventData;
import org.teamapps.ux.component.table.ColumnSizeChangeEventData;
import org.teamapps.ux.component.table.FieldValueChangedEventData;
import org.teamapps.ux.component.table.ListTableModel;
import org.teamapps.ux.component.table.SelectionFrame;
import org.teamapps.ux.component.table.SortingChangedEventData;
import org.teamapps.ux.component.table.TableCellCoordinates;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableDataRequestEventData;
import org.teamapps.ux.component.table.TableModel;

public class Table<RECORD>
extends AbstractInfiniteListComponent<RECORD, TableModel<RECORD>>
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(Table.class);
    public final Event<CellEditingStartedEvent<RECORD, ?>> onCellEditingStarted = new Event();
    public final Event<CellEditingStoppedEvent<RECORD, ?>> onCellEditingStopped = new Event();
    public final Event<FieldValueChangedEventData<RECORD, ?>> onCellValueChanged = new Event();
    public final Event<List<RECORD>> onRowsSelected = new Event();
    public final Event<RECORD> onSingleRowSelected = new Event();
    public final Event<List<RECORD>> onMultipleRowsSelected = new Event();
    public final Event<CellClickedEvent<RECORD, ?>> onCellClicked = new Event();
    public final Event<SortingChangedEventData> onSortingChanged = new Event();
    public final Event<TableDataRequestEventData> onTableDataRequest = new Event();
    public final Event<ColumnOrderChangeEventData<RECORD, ?>> onColumnOrderChange = new Event();
    public final Event<ColumnSizeChangeEventData<RECORD, ?>> onColumnSizeChange = new Event();
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();
    private PropertyInjector<RECORD> propertyInjector = new BeanPropertyInjector();
    private int clientRecordIdCounter = 0;
    private List<RECORD> selectedRecords = List.of();
    private TableCellCoordinates<RECORD> activeEditorCell;
    private final Map<RECORD, Map<String, Object>> transientChangesByRecordAndPropertyName = new HashMap<RECORD, Map<String, Object>>();
    private final Map<RECORD, Map<String, List<FieldMessage>>> cellMessages = new HashMap<RECORD, Map<String, List<FieldMessage>>>();
    private final Map<RECORD, Set<String>> markedCells = new HashMap<RECORD, Set<String>>();
    private final List<TableColumn<RECORD, ?>> columns = new ArrayList();
    private boolean displayAsList;
    private boolean forceFitWidth;
    private int rowHeight = 28;
    private boolean stripedRows = true;
    private boolean hideHeaders;
    private boolean allowMultiRowSelection = false;
    private boolean showRowCheckBoxes;
    private boolean showNumbering;
    private boolean textSelectionEnabled = true;
    private Sorting sorting;
    private boolean editable;
    private boolean ensureEmptyLastRow;
    private boolean treeMode;
    private String indentedColumnName;
    private int indentation = 15;
    private SelectionFrame selectionFrame;
    private boolean showHeaderRow = false;
    private int headerRowHeight = 28;
    private final Map<String, AbstractField<?>> headerRowFields = new HashMap(0);
    private boolean showFooterRow = false;
    private int footerRowHeight = 28;
    private final Map<String, AbstractField<?>> footerRowFields = new HashMap(0);
    private final List<RECORD> topNonModelRecords = new ArrayList<RECORD>();
    private final List<RECORD> bottomNonModelRecords = new ArrayList<RECORD>();
    private Function<RECORD, Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;
    private int rowBorderWidth;

    public Table() {
        this(new ArrayList());
    }

    public Table(List<TableColumn<RECORD, ?>> columns) {
        super(new ListTableModel());
        columns.forEach(this::addColumn);
    }

    public static <RECORD> Table<RECORD> create() {
        return new Table<RECORD>();
    }

    public void addColumn(TableColumn<RECORD, ?> column) {
        this.addColumn(column, this.columns.size());
    }

    public void addColumn(TableColumn<RECORD, ?> column, int index) {
        this.addColumns(List.of(column), index);
    }

    public <VALUE> TableColumn<RECORD, VALUE> addColumn(String propertyName, String title, AbstractField<VALUE> field) {
        return this.addColumn(propertyName, null, title, field, 150);
    }

    public <VALUE> TableColumn<RECORD, VALUE> addColumn(String propertyName, Icon<?, ?> icon, String title, AbstractField<VALUE> field) {
        return this.addColumn(propertyName, icon, title, field, 150);
    }

    public <VALUE> TableColumn<RECORD, VALUE> addColumn(String propertyName, Icon<?, ?> icon, String title, AbstractField<VALUE> field, int defaultWidth) {
        TableColumn column = new TableColumn(propertyName, icon, title, field, defaultWidth);
        this.addColumn(column);
        return column;
    }

    public void addColumns(List<TableColumn<RECORD, ?>> newColumns, int index) {
        this.columns.addAll(index, newColumns);
        newColumns.forEach(column -> {
            column.setTable(this);
            AbstractField field = column.getField();
            field.setParent(this);
        });
        if (this.isRendered()) {
            this.getSessionContext().queueCommand((UiCommand<?>)new UiTable.AddColumnsCommand(this.getId(), newColumns.stream().map(TableColumn::createUiTableColumn).collect(Collectors.toList()), index));
            this.refreshData();
        }
    }

    public void removeColumn(String propertyName) {
        this.columns.stream().filter(c -> Objects.equals(c.getPropertyName(), propertyName)).findFirst().ifPresent(this::removeColumn);
    }

    public void removeColumn(TableColumn<RECORD, ?> column) {
        this.removeColumns(Collections.singletonList(column));
    }

    public void removeColumns(List<TableColumn<RECORD, ?>> obsoleteColumns) {
        this.columns.removeAll(obsoleteColumns);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand((UiCommand<?>)new UiTable.RemoveColumnsCommand(this.getId(), obsoleteColumns.stream().map(TableColumn::getPropertyName).collect(Collectors.toList())));
        }
    }

    @Override
    protected void preRegisteringModel(TableModel<RECORD> model) {
        model.setSorting(this.sorting);
    }

    @Override
    public UiComponent createUiComponent() {
        List columns = this.columns.stream().map(TableColumn::createUiTableColumn).collect(Collectors.toList());
        UiTable uiTable = new UiTable(columns);
        this.mapAbstractUiComponentProperties((UiComponent)uiTable);
        uiTable.setSelectionFrame(this.selectionFrame != null ? this.selectionFrame.createUiSelectionFrame() : null);
        uiTable.setDisplayAsList(this.displayAsList);
        uiTable.setForceFitWidth(this.forceFitWidth);
        uiTable.setRowHeight(this.rowHeight);
        uiTable.setStripedRows(this.stripedRows);
        uiTable.setHideHeaders(this.hideHeaders);
        uiTable.setAllowMultiRowSelection(this.allowMultiRowSelection);
        uiTable.setShowRowCheckBoxes(this.showRowCheckBoxes);
        uiTable.setShowNumbering(this.showNumbering);
        uiTable.setTextSelectionEnabled(this.textSelectionEnabled);
        uiTable.setSortField(this.sorting != null ? this.sorting.getFieldName() : null);
        uiTable.setSortDirection(this.sorting != null ? this.sorting.getSortDirection().toUiSortDirection() : null);
        uiTable.setEditable(this.editable);
        uiTable.setTreeMode(this.treeMode);
        uiTable.setIndentedColumnName(this.indentedColumnName);
        uiTable.setIndentation(this.indentation);
        uiTable.setShowHeaderRow(this.showHeaderRow);
        uiTable.setHeaderRowHeight(this.headerRowHeight);
        uiTable.setHeaderRowFields(this.headerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference())));
        uiTable.setShowFooterRow(this.showFooterRow);
        uiTable.setFooterRowHeight(this.footerRowHeight);
        uiTable.setFooterRowFields(this.footerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference())));
        uiTable.setContextMenuEnabled(this.contextMenuProvider != null);
        return uiTable;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TABLE_ROWS_SELECTED: {
                UiTable.RowsSelectedEvent rowsSelectedEvent = (UiTable.RowsSelectedEvent)event;
                this.selectedRecords = this.renderedRecords.getRecords(rowsSelectedEvent.getRecordIds());
                this.onRowsSelected.fire(this.selectedRecords);
                if (this.selectedRecords.size() == 1) {
                    this.onSingleRowSelected.fire(this.selectedRecords.get(0));
                    break;
                }
                if (this.selectedRecords.size() <= 1) break;
                this.onMultipleRowsSelected.fire(this.selectedRecords);
                break;
            }
            case UI_TABLE_CELL_CLICKED: {
                UiTable.CellClickedEvent cellClickedEvent = (UiTable.CellClickedEvent)event;
                Object record = this.renderedRecords.getRecord(cellClickedEvent.getRecordId());
                TableColumn column = this.getColumnByPropertyName(cellClickedEvent.getColumnPropertyName());
                if (record == null || column == null) break;
                this.onCellClicked.fire(new CellClickedEvent(record, column));
                break;
            }
            case UI_TABLE_CELL_EDITING_STARTED: {
                UiTable.CellEditingStartedEvent editingStartedEvent = (UiTable.CellEditingStartedEvent)event;
                Object record = this.renderedRecords.getRecord(editingStartedEvent.getRecordId());
                TableColumn column = this.getColumnByPropertyName(editingStartedEvent.getColumnPropertyName());
                if (record == null || column == null) {
                    return;
                }
                this.activeEditorCell = new TableCellCoordinates(record, editingStartedEvent.getColumnPropertyName());
                this.selectedRecords = List.of(this.activeEditorCell.getRecord());
                Object cellValue = this.getCellValue(record, column);
                AbstractField<?> activeEditorField = this.getActiveEditorField();
                activeEditorField.setValue(cellValue);
                List<FieldMessage> cellMessages = this.getCellMessages(record, editingStartedEvent.getColumnPropertyName());
                List<FieldMessage> columnMessages = this.getColumnByPropertyName(editingStartedEvent.getColumnPropertyName()).getMessages();
                if (columnMessages == null) {
                    columnMessages = Collections.emptyList();
                }
                ArrayList<FieldMessage> messages = new ArrayList<FieldMessage>(cellMessages);
                messages.addAll(columnMessages);
                activeEditorField.setCustomFieldMessages(messages);
                this.onCellEditingStarted.fire(new CellEditingStartedEvent(record, column, cellValue));
                break;
            }
            case UI_TABLE_CELL_EDITING_STOPPED: {
                this.activeEditorCell = null;
                UiTable.CellEditingStoppedEvent editingStoppedEvent = (UiTable.CellEditingStoppedEvent)event;
                Object record = this.renderedRecords.getRecord(editingStoppedEvent.getRecordId());
                TableColumn column = this.getColumnByPropertyName(editingStoppedEvent.getColumnPropertyName());
                if (record == null || column == null) {
                    return;
                }
                this.onCellEditingStopped.fire(new CellEditingStoppedEvent(record, column));
                break;
            }
            case UI_TABLE_CELL_VALUE_CHANGED: {
                UiTable.CellValueChangedEvent changeEvent = (UiTable.CellValueChangedEvent)event;
                Object record = this.renderedRecords.getRecord(changeEvent.getRecordId());
                TableColumn column = this.getColumnByPropertyName(changeEvent.getColumnPropertyName());
                if (record == null || column == null) {
                    return;
                }
                Object value = column.getField().convertUiValueToUxValue(changeEvent.getValue());
                this.transientChangesByRecordAndPropertyName.computeIfAbsent(record, idValue -> new HashMap()).put(column.getPropertyName(), value);
                this.onCellValueChanged.fire(new FieldValueChangedEventData(record, column, value));
                break;
            }
            case UI_TABLE_SORTING_CHANGED: {
                UiTable.SortingChangedEvent sortingChangedEvent = (UiTable.SortingChangedEvent)event;
                String sortField = sortingChangedEvent.getSortField();
                SortDirection sortDirection = SortDirection.fromUiSortDirection(sortingChangedEvent.getSortDirection());
                this.sorting = sortField != null && sortDirection != null ? new Sorting(sortField, sortDirection) : null;
                ((TableModel)this.getModel()).setSorting(this.sorting);
                this.onSortingChanged.fire(new SortingChangedEventData(sortingChangedEvent.getSortField(), SortDirection.fromUiSortDirection(sortingChangedEvent.getSortDirection())));
                break;
            }
            case UI_TABLE_DISPLAYED_RANGE_CHANGED: {
                UiTable.DisplayedRangeChangedEvent d = (UiTable.DisplayedRangeChangedEvent)event;
                try {
                    this.handleScrollOrResize(ItemRange.startLength(d.getStartIndex(), d.getLength()));
                }
                catch (DuplicateEntriesException e) {
                    LOGGER.warn("DuplicateEntriesException while retrieving data from model. This means the underlying data of the model has changed without the model notifying this component, so will refresh the whole data of this component.");
                    this.refreshData();
                }
                break;
            }
            case UI_TABLE_FIELD_ORDER_CHANGE: {
                UiTable.FieldOrderChangeEvent fieldOrderChangeEvent = (UiTable.FieldOrderChangeEvent)event;
                TableColumn column = this.getColumnByPropertyName(fieldOrderChangeEvent.getColumnPropertyName());
                this.onColumnOrderChange.fire(new ColumnOrderChangeEventData(column, fieldOrderChangeEvent.getPosition()));
                break;
            }
            case UI_TABLE_COLUMN_SIZE_CHANGE: {
                UiTable.ColumnSizeChangeEvent columnSizeChangeEvent = (UiTable.ColumnSizeChangeEvent)event;
                TableColumn column = this.getColumnByPropertyName(columnSizeChangeEvent.getColumnPropertyName());
                this.onColumnSizeChange.fire(new ColumnSizeChangeEventData(column, columnSizeChangeEvent.getSize()));
                break;
            }
            case UI_TABLE_CONTEXT_MENU_REQUESTED: {
                UiTable.ContextMenuRequestedEvent e = (UiTable.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                Object record = this.renderedRecords.getRecord(e.getRecordId());
                if (record != null && this.contextMenuProvider != null) {
                    Component contextMenuContent = this.contextMenuProvider.apply(record);
                    if (contextMenuContent != null) {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                        break;
                    }
                    this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                    break;
                }
                this.closeContextMenu();
                break;
            }
        }
    }

    private <VALUE> VALUE getCellValue(RECORD record, TableColumn<RECORD, VALUE> column) {
        Map changesForRecord = this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap());
        boolean changed = changesForRecord.containsKey(column.getPropertyName());
        Object cellValue = changed ? changesForRecord.get(column.getPropertyName()) : this.extractRecordProperty(record, column);
        return (VALUE)cellValue;
    }

    private <VALUE> VALUE extractRecordProperty(RECORD record, TableColumn<RECORD, VALUE> column) {
        if (column.getValueExtractor() != null) {
            return column.getValueExtractor().extract(record);
        }
        return (VALUE)this.propertyProvider.getValues(record, Collections.singletonList(column.getPropertyName())).get(column.getPropertyName());
    }

    private Map<String, Object> extractRecordProperties(RECORD record) {
        Map<Boolean, List<TableColumn>> columnsWithAndWithoutValueExtractor = this.columns.stream().collect(Collectors.partitioningBy(c -> c.getValueExtractor() != null));
        HashMap<String, Object> valuesByPropertyName = new HashMap<String, Object>(this.propertyProvider.getValues(record, columnsWithAndWithoutValueExtractor.get(false).stream().map(TableColumn::getPropertyName).collect(Collectors.toList())));
        columnsWithAndWithoutValueExtractor.get(true).forEach(recordTableColumn -> valuesByPropertyName.put(recordTableColumn.getPropertyName(), recordTableColumn.getValueExtractor().extract(record)));
        return valuesByPropertyName;
    }

    public List<String> getColumnPropertyNames() {
        return this.columns.stream().map(TableColumn::getPropertyName).collect(Collectors.toList());
    }

    public TableCellCoordinates<RECORD> getActiveEditorCell() {
        return this.activeEditorCell;
    }

    public AbstractField<?> getActiveEditorField() {
        if (this.activeEditorCell != null) {
            return this.getColumnByPropertyName(this.activeEditorCell.getPropertyName()).getField();
        }
        return null;
    }

    public void setCellValue(RECORD record, String propertyName, Object value) {
        this.transientChangesByRecordAndPropertyName.computeIfAbsent(record, record1 -> new HashMap()).put(propertyName, value);
        UiIdentifiableClientRecord uiRecordIdOrNull = this.renderedRecords.getUiRecord(record);
        if (uiRecordIdOrNull != null) {
            Object uiValue = this.getColumnByPropertyName(propertyName).getField().convertUxValueToUiValue(value);
            this.queueCommandIfRendered(() -> new UiTable.SetCellValueCommand(this.getId(), uiRecordIdOrNull.getId(), propertyName, uiValue));
        }
    }

    public void focusCell(RECORD record, String propertyName) {
    }

    public void setCellMarked(RECORD record, String propertyName, boolean mark) {
        if (mark) {
            this.markedCells.computeIfAbsent(record, record1 -> new HashSet()).add(propertyName);
        } else {
            Set markedCellPropertyNames = this.markedCells.getOrDefault(record, Collections.emptySet());
            if (markedCellPropertyNames.isEmpty()) {
                this.markedCells.remove(record);
            }
        }
        UiIdentifiableClientRecord uiRecordIdOrNull = this.renderedRecords.getUiRecord(record);
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.MarkTableFieldCommand(this.getId(), uiRecordIdOrNull.getId(), propertyName, mark));
        }
    }

    public void clearRecordMarkings(RECORD record) {
        this.markedCells.remove(record);
        this.updateSingleRecordOnClient(record);
    }

    public void clearAllCellMarkings() {
        this.markedCells.clear();
        this.queueCommandIfRendered(() -> new UiTable.ClearAllFieldMarkingsCommand(this.getId()));
    }

    public void setRecordBold(RECORD record, boolean bold) {
        UiIdentifiableClientRecord uiRecordIdOrNull = this.renderedRecords.getUiRecord(record);
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.SetRecordBoldCommand(this.getId(), uiRecordIdOrNull.getId(), bold));
        }
    }

    public void setSelectedRecord(RECORD record) {
        this.setSelectedRecord(record, false);
    }

    public void setSelectedRecord(RECORD record, boolean scrollToRecordIfAvailable) {
        this.setSelectedRecords(record != null ? List.of(record) : List.of(), scrollToRecordIfAvailable);
    }

    public void setSelectedRecords(List<RECORD> records) {
        this.setSelectedRecords(records, false);
    }

    public void setSelectedRecords(List<RECORD> records, boolean scrollToFirstIfAvailable) {
        this.selectedRecords = records == null ? List.of() : List.copyOf(records);
        this.queueCommandIfRendered(() -> new UiTable.SelectRecordsCommand(this.getId(), this.renderedRecords.getUiRecordIds(this.selectedRecords), scrollToFirstIfAvailable));
    }

    public void setSelectedRow(int rowIndex) {
        this.setSelectedRow(rowIndex, false);
    }

    public void setSelectedRow(int rowIndex, boolean scrollTo) {
        this.getRecordByRowIndex(rowIndex).ifPresentOrElse(record -> {
            this.selectedRecords = List.of(record);
            this.queueCommandIfRendered(() -> new UiTable.SelectRowsCommand(this.getId(), List.of(Integer.valueOf(rowIndex)), scrollTo));
        }, () -> {
            this.selectedRecords = List.of();
            this.queueCommandIfRendered(() -> new UiTable.SelectRowsCommand(this.getId(), List.of(), scrollTo));
        });
    }

    public void setSelectedRows(List<Integer> rowIndexes) {
        this.setSelectedRows(rowIndexes, false);
    }

    public void setSelectedRows(List<Integer> rowIndexes, boolean scrollToFirst) {
        this.selectedRecords = this.getRecordsByRowIndexes(rowIndexes);
        this.queueCommandIfRendered(() -> new UiTable.SelectRowsCommand(this.getId(), rowIndexes, scrollToFirst));
    }

    private List<RECORD> getRecordsByRowIndexes(List<Integer> rowIndexes) {
        return rowIndexes.stream().flatMap(rowIndex -> this.getRecordByRowIndex((int)rowIndex).stream()).collect(Collectors.toList());
    }

    private Optional<RECORD> getRecordByRowIndex(int rowIndex) {
        List records = ((TableModel)this.getModel()).getRecords(rowIndex, 1);
        if (records.size() >= 1) {
            if (records.size() > 1) {
                LOGGER.warn("Got multiple records from model when only asking for one! Taking the first one.");
            }
            return Optional.of(records.get(0));
        }
        LOGGER.error("Could not find record at row index {}", (Object)rowIndex);
        return Optional.empty();
    }

    protected void updateColumnMessages(TableColumn<RECORD, ?> tableColumn) {
        this.queueCommandIfRendered(() -> new UiTable.SetColumnMessagesCommand(this.getId(), tableColumn.getPropertyName(), tableColumn.getMessages().stream().map(message -> message.createUiFieldMessage(FieldMessage.Position.POPOVER, FieldMessage.Visibility.ON_HOVER_OR_FOCUS)).collect(Collectors.toList())));
    }

    public List<FieldMessage> getCellMessages(RECORD record, String propertyName) {
        return this.cellMessages.getOrDefault(record, Collections.emptyMap()).getOrDefault(propertyName, Collections.emptyList());
    }

    public void addCellMessage(RECORD record, String propertyName, FieldMessage message) {
        List cellMessages = this.cellMessages.computeIfAbsent(record, x -> new HashMap()).computeIfAbsent(propertyName, x -> new ArrayList());
        cellMessages.add(message);
        this.updateSingleCellMessages(record, propertyName, cellMessages);
    }

    public void removeCellMessage(RECORD record, String propertyName, FieldMessage message) {
        List cellMessages = this.cellMessages.computeIfAbsent(record, x -> new HashMap()).computeIfAbsent(propertyName, x -> new ArrayList());
        cellMessages.remove(message);
        this.updateSingleCellMessages(record, propertyName, cellMessages);
    }

    public List<FieldMessage> validateRecord(RECORD record) {
        return this.validateRowInternal(record, false);
    }

    public List<FieldMessage> validateRow(RECORD record) {
        return this.validateRowInternal(record, true);
    }

    private List<FieldMessage> validateRowInternal(RECORD record, boolean considerChangedCellValues) {
        Map<String, Object> stringObjectMap = this.extractRecordProperties(record);
        if (considerChangedCellValues) {
            stringObjectMap.putAll(this.getChangedCellValues(record));
        }
        return this.getColumns().stream().flatMap(column -> column.getField().getValidators().stream().flatMap(validator -> {
            List<FieldMessage> messages = validator.validate(stringObjectMap.get(column.getPropertyName()));
            if (messages != null) {
                return messages.stream();
            }
            return Stream.empty();
        })).collect(Collectors.toList());
    }

    private void updateSingleCellMessages(RECORD record, String propertyName, List<FieldMessage> cellMessages) {
        UiIdentifiableClientRecord uiRecordId = this.renderedRecords.getUiRecord(record);
        if (uiRecordId != null) {
            this.queueCommandIfRendered(() -> new UiTable.SetSingleCellMessagesCommand(this.getId(), uiRecordId.getId(), propertyName, cellMessages.stream().map(m -> m.createUiFieldMessage(FieldMessage.Position.POPOVER, FieldMessage.Visibility.ON_HOVER_OR_FOCUS)).collect(Collectors.toList())));
        }
    }

    protected void updateColumnVisibility(TableColumn<RECORD, ?> tableColumn) {
        this.queueCommandIfRendered(() -> new UiTable.SetColumnVisibilityCommand(this.getId(), tableColumn.getPropertyName(), tableColumn.isVisible()));
    }

    public List<RECORD> getTopNonModelRecords() {
        return List.copyOf(this.topNonModelRecords);
    }

    public List<RECORD> getBottomNonModelRecords() {
        return List.copyOf(this.bottomNonModelRecords);
    }

    public List<RECORD> getNonModelRecords(boolean top) {
        return top ? this.getTopNonModelRecords() : this.getBottomNonModelRecords();
    }

    public void addTopNonModelRecord(RECORD record) {
        this.topNonModelRecords.add(0, record);
        this.refreshData();
    }

    public void addBottomNonModelRecord(RECORD record) {
        this.bottomNonModelRecords.add(record);
        this.refreshData();
    }

    public void addNonModelRecord(RECORD record, boolean addToTop) {
        if (addToTop) {
            this.addTopNonModelRecord(record);
        } else {
            this.addBottomNonModelRecord(record);
        }
    }

    public void removeTopNonModelRecord(RECORD record) {
        this.topNonModelRecords.remove(record);
        this.refreshData();
    }

    public void removeBottomNonModelRecord(RECORD record) {
        this.bottomNonModelRecords.remove(record);
        this.refreshData();
    }

    public void removeNonModelRecord(RECORD record) {
        this.topNonModelRecords.remove(record);
        this.bottomNonModelRecords.remove(record);
        this.refreshData();
    }

    public void removeNonModelRecord(RECORD record, boolean top) {
        if (top) {
            this.removeTopNonModelRecord(record);
        } else {
            this.removeBottomNonModelRecord(record);
        }
    }

    public void removeAllTopNonModelRecords() {
        this.topNonModelRecords.clear();
        this.refreshData();
    }

    public void removeAllBottomNonModelRecords() {
        this.topNonModelRecords.clear();
        this.refreshData();
    }

    public void removeAllNonModelRecords() {
        this.topNonModelRecords.clear();
        this.bottomNonModelRecords.clear();
        this.refreshData();
    }

    public void clearRecordMessages(RECORD record) {
        this.cellMessages.remove(record);
        this.updateSingleRecordOnClient(record);
    }

    public void updateRecordMessages(RECORD record, Map<String, List<FieldMessage>> messages) {
        this.cellMessages.put(record, new HashMap<String, List<FieldMessage>>(messages));
        this.updateSingleRecordOnClient(record);
    }

    @Override
    protected void handleModelRecordsRemoved(RecordsRemovedEvent<RECORD> deleteEvent) {
        for (int i = Math.max(deleteEvent.getStart(), this.renderedRecords.getStartIndex()); i < Math.min(deleteEvent.getEnd(), this.renderedRecords.getEndIndex()); ++i) {
            this.clearMetaDataForRecord(this.renderedRecords.getRecordByIndex(i));
        }
        super.handleModelRecordsRemoved(deleteEvent);
    }

    @Override
    protected void handleModelRecordsChanged(RecordsChangedEvent<RECORD> changeEvent) {
        for (int i = Math.max(changeEvent.getStart(), this.renderedRecords.getStartIndex()); i < Math.min(changeEvent.getEnd(), this.renderedRecords.getEndIndex()); ++i) {
            this.clearMetaDataForRecord(this.renderedRecords.getRecordByIndex(i));
        }
        super.handleModelRecordsChanged(changeEvent);
    }

    private void clearMetaDataForRecord(RECORD record) {
        this.transientChangesByRecordAndPropertyName.remove(record);
        this.cellMessages.remove(record);
        this.markedCells.remove(record);
    }

    public void refreshData() {
        this.refresh();
    }

    @Override
    protected void sendUpdateDataCommandToClient(int start, List<Integer> uiRecordIds, List<UiIdentifiableClientRecord> newUiRecords, int totalNumberOfRecords) {
        this.queueCommandIfRendered(() -> {
            LOGGER.debug("SENDING: renderedRange.start: {}; uiRecordIds.size: {}; renderedRecords.size: {}; newUiRecords.size: {}; totalCount: {}", new Object[]{start, uiRecordIds.size(), this.renderedRecords.size(), newUiRecords.size(), totalNumberOfRecords});
            return new UiTable.UpdateDataCommand(this.getId(), start, uiRecordIds, newUiRecords, totalNumberOfRecords);
        });
    }

    private int getTotalRecordsCount() {
        return this.getModelCount() + this.topNonModelRecords.size() + this.bottomNonModelRecords.size();
    }

    @Override
    protected List<RECORD> retrieveRecords(int startIndex, int length) {
        int totalBottomRecords;
        int totalModelRecords;
        if (startIndex < 0 || length < 0) {
            LOGGER.warn("Data coordinates do not make sense: startIndex {}, length {}", (Object)startIndex, (Object)length);
            return Collections.emptyList();
        }
        int endIndex = startIndex + length;
        int totalTopRecords = this.topNonModelRecords.size();
        if (endIndex > totalTopRecords + (totalModelRecords = this.getModelCount()) + (totalBottomRecords = this.bottomNonModelRecords.size())) {
            endIndex = Math.max(totalTopRecords + totalModelRecords + totalBottomRecords, startIndex);
            length = endIndex - startIndex;
        }
        if (startIndex < totalTopRecords && endIndex <= totalTopRecords) {
            return this.topNonModelRecords.stream().skip(startIndex).limit(length).collect(Collectors.toList());
        }
        if (startIndex < totalTopRecords && endIndex <= totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.topNonModelRecords.stream().skip(startIndex).limit(totalTopRecords - startIndex).collect(Collectors.toList()));
            records.addAll(this.retrieveRecordsFromModel(0, length - records.size()));
            return records;
        }
        if (startIndex < totalTopRecords && endIndex > totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.topNonModelRecords.stream().skip(startIndex).limit(totalTopRecords - startIndex).collect(Collectors.toList()));
            records.addAll(this.retrieveRecordsFromModel(0, totalModelRecords));
            records.addAll(this.bottomNonModelRecords.stream().skip(0L).limit(length - records.size()).collect(Collectors.toList()));
            return records;
        }
        if (startIndex >= totalTopRecords && startIndex < totalTopRecords + totalModelRecords && endIndex <= totalTopRecords + totalModelRecords) {
            return this.retrieveRecordsFromModel(startIndex - this.topNonModelRecords.size(), length);
        }
        if (startIndex >= totalTopRecords && startIndex < totalTopRecords + totalModelRecords && endIndex > totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.retrieveRecordsFromModel(startIndex - this.topNonModelRecords.size(), endIndex - startIndex - totalTopRecords));
            records.addAll(this.bottomNonModelRecords.stream().skip(0L).limit(length - records.size()).collect(Collectors.toList()));
            return records;
        }
        if (startIndex >= totalTopRecords + totalModelRecords) {
            return this.bottomNonModelRecords.stream().skip(startIndex - totalTopRecords - totalModelRecords).limit(length).collect(Collectors.toList());
        }
        LOGGER.error("This path should never be reached!");
        return Collections.emptyList();
    }

    private List<RECORD> retrieveRecordsFromModel(int startIndex, int length) {
        List records = ((TableModel)this.getModel()).getRecords(startIndex, length);
        if (records.size() == length) {
            return records;
        }
        if (records.size() < length) {
            LOGGER.warn("TableModel did not return the requested amount of data!");
            return records;
        }
        LOGGER.warn("TableModel returned too much data. Truncating!");
        return new ArrayList(records.subList(0, length));
    }

    private void applyTransientChangesToClientRecord(UiTableClientRecord uiRecord) {
        Map<String, Object> changes = this.transientChangesByRecordAndPropertyName.get(this.renderedRecords.getRecord(uiRecord.getId()));
        if (changes != null) {
            changes.forEach((key, value) -> uiRecord.getValues().put(key, this.getColumnByPropertyName((String)key).getField().convertUxValueToUiValue(value)));
        }
    }

    public void cancelEditing() {
        TableCellCoordinates<RECORD> activeEditorCell = this.getActiveEditorCell();
        UiIdentifiableClientRecord uiRecord = this.renderedRecords.getUiRecord(activeEditorCell.getRecord());
        if (uiRecord != null) {
            this.queueCommandIfRendered(() -> new UiTable.CancelEditingCellCommand(this.getId(), uiRecord.getId(), activeEditorCell.getPropertyName()));
        }
    }

    private Map<String, List<UiFieldMessage>> createUiFieldMessagesForRecord(Map<String, List<FieldMessage>> recordFieldMessages) {
        return recordFieldMessages.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(fieldMessage -> fieldMessage.createUiFieldMessage(FieldMessage.Position.POPOVER, FieldMessage.Visibility.ON_HOVER_OR_FOCUS)).collect(Collectors.toList())));
    }

    @Override
    protected UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiTableClientRecord clientRecord = new UiTableClientRecord();
        clientRecord.setId(++this.clientRecordIdCounter);
        Map<String, Object> uxValues = this.extractRecordProperties(record);
        Map uiValues = this.columns.stream().collect(HashMap::new, (map, column) -> map.put(column.getPropertyName(), column.getField().convertUxValueToUiValue(uxValues.get(column.getPropertyName()))), HashMap::putAll);
        clientRecord.setValues(uiValues);
        clientRecord.setSelected(this.selectedRecords.stream().anyMatch(r -> this.customEqualsAndHashCode.getEquals().test(r, record)));
        clientRecord.setMessages(this.createUiFieldMessagesForRecord(this.cellMessages.getOrDefault(record, Collections.emptyMap())));
        clientRecord.setMarkings(new ArrayList(this.markedCells.getOrDefault(record, Collections.emptySet())));
        this.applyTransientChangesToClientRecord(clientRecord);
        return clientRecord;
    }

    public List<TableColumn<RECORD, ?>> getColumns() {
        return this.columns;
    }

    public boolean isDisplayAsList() {
        return this.displayAsList;
    }

    public void setDisplayAsList(boolean displayAsList) {
        boolean changed = this.displayAsList != displayAsList;
        this.displayAsList = displayAsList;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isForceFitWidth() {
        return this.forceFitWidth;
    }

    public void setForceFitWidth(boolean forceFitWidth) {
        boolean changed = forceFitWidth != this.forceFitWidth;
        this.forceFitWidth = forceFitWidth;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    private UiRefreshableTableConfigUpdate createUiRefreshableTableConfigUpdate() {
        UiRefreshableTableConfigUpdate ui = new UiRefreshableTableConfigUpdate();
        ui.setForceFitWidth(this.forceFitWidth);
        ui.setRowHeight(this.rowHeight);
        ui.setAllowMultiRowSelection(this.allowMultiRowSelection);
        ui.setTextSelectionEnabled(this.textSelectionEnabled);
        ui.setEditable(this.editable);
        ui.setShowHeaderRow(this.showHeaderRow);
        ui.setHeaderRowHeight(this.headerRowHeight);
        ui.setShowFooterRow(this.showFooterRow);
        ui.setFooterRowHeight(this.footerRowHeight);
        return ui;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        boolean changed = rowHeight != this.rowHeight;
        this.rowHeight = rowHeight;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public boolean isStripedRows() {
        return this.stripedRows;
    }

    public void setStripedRows(boolean stripedRows) {
        boolean changed = stripedRows != this.stripedRows;
        this.stripedRows = stripedRows;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void setStripedRowColorEven(Color stripedRowColorEven) {
        this.setCssStyle(".striped-rows .slick-row.even", "background-color", stripedRowColorEven != null ? stripedRowColorEven.toHtmlColorString() : null);
    }

    public void setStripedRowColorOdd(Color stripedRowColorOdd) {
        this.setCssStyle(".striped-rows .slick-row.odd", "background-color", stripedRowColorOdd != null ? stripedRowColorOdd.toHtmlColorString() : null);
    }

    public boolean isHideHeaders() {
        return this.hideHeaders;
    }

    public void setHideHeaders(boolean hideHeaders) {
        boolean changed = hideHeaders != this.hideHeaders;
        this.hideHeaders = hideHeaders;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isAllowMultiRowSelection() {
        return this.allowMultiRowSelection;
    }

    public void setAllowMultiRowSelection(boolean allowMultiRowSelection) {
        boolean changed = allowMultiRowSelection != this.allowMultiRowSelection;
        this.allowMultiRowSelection = allowMultiRowSelection;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public void setSelectionColor(Color selectionColor) {
        this.setCssStyle(".slick-cell.selected", "background-color", selectionColor != null ? selectionColor.toHtmlColorString() : null);
    }

    public void setRowBorderWidth(int rowBorderWidth) {
        boolean changed = rowBorderWidth != this.rowBorderWidth;
        this.rowBorderWidth = rowBorderWidth;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
        this.setCssStyle(".slick-cell", "border-bottom-width", rowBorderWidth + "px");
    }

    public void setRowBorderColor(Color rowBorderColor) {
        this.setCssStyle(".slick-cell", "border-color", rowBorderColor != null ? rowBorderColor.toHtmlColorString() : null);
    }

    public boolean isShowRowCheckBoxes() {
        return this.showRowCheckBoxes;
    }

    public void setShowRowCheckBoxes(boolean showRowCheckBoxes) {
        boolean changed = showRowCheckBoxes != this.showRowCheckBoxes;
        this.showRowCheckBoxes = showRowCheckBoxes;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isShowNumbering() {
        return this.showNumbering;
    }

    public void setShowNumbering(boolean showNumbering) {
        boolean changed = showNumbering != this.showNumbering;
        this.showNumbering = showNumbering;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isTextSelectionEnabled() {
        return this.textSelectionEnabled;
    }

    public void setTextSelectionEnabled(boolean textSelectionEnabled) {
        boolean changed = textSelectionEnabled != this.textSelectionEnabled;
        this.textSelectionEnabled = textSelectionEnabled;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public void setSorting(String sortField, SortDirection sortDirection) {
        this.setSorting(sortField != null && sortDirection != null ? new Sorting(sortField, sortDirection) : null);
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
        TableModel model = (TableModel)this.getModel();
        if (model != null) {
            model.setSorting(sorting);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean changed = editable != this.editable;
        this.editable = editable;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public boolean isEnsureEmptyLastRow() {
        return this.ensureEmptyLastRow;
    }

    public void setEnsureEmptyLastRow(boolean ensureEmptyLastRow) {
        boolean changed = ensureEmptyLastRow != this.ensureEmptyLastRow;
        this.ensureEmptyLastRow = ensureEmptyLastRow;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isTreeMode() {
        return this.treeMode;
    }

    public void setTreeMode(boolean treeMode) {
        boolean changed = treeMode != this.treeMode;
        this.treeMode = treeMode;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public String getIndentedColumnName() {
        return this.indentedColumnName;
    }

    public void setIndentedColumnName(String indentedColumnName) {
        boolean changed = !Objects.equals(indentedColumnName, this.indentedColumnName);
        this.indentedColumnName = indentedColumnName;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        boolean changed = indentation != this.indentation;
        this.indentation = indentation;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public SelectionFrame getSelectionFrame() {
        return this.selectionFrame;
    }

    public void setSelectionFrame(SelectionFrame selectionFrame) {
        boolean changed = !Objects.equals(selectionFrame, this.selectionFrame);
        this.selectionFrame = selectionFrame;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isShowHeaderRow() {
        return this.showHeaderRow;
    }

    public void setShowHeaderRow(boolean showHeaderRow) {
        boolean changed = showHeaderRow != this.showHeaderRow;
        this.showHeaderRow = showHeaderRow;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public void setHeaderRowBorderWidth(int headerRowBorderWidth) {
        this.setCssStyle(".slick-headerrow", "border-bottom-width", headerRowBorderWidth + "px");
    }

    public void setHeaderRowBorderColor(Color headerRowBorderColor) {
        this.setCssStyle(".slick-headerrow", "border-bottom-color", headerRowBorderColor != null ? headerRowBorderColor.toHtmlColorString() : null);
    }

    public int getHeaderRowHeight() {
        return this.headerRowHeight;
    }

    public void setHeaderRowHeight(int headerRowHeight) {
        boolean changed = headerRowHeight != this.headerRowHeight;
        this.headerRowHeight = headerRowHeight;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public void setHeaderRowBackgroundColor(Color headerRowBackgroundColor) {
        this.setCssStyle(".slick-headerrow", "background-color", headerRowBackgroundColor != null ? headerRowBackgroundColor.toHtmlColorString() : null);
    }

    public Map<String, AbstractField<?>> getHeaderRowFields() {
        return Collections.unmodifiableMap(this.headerRowFields);
    }

    public void setHeaderRowFields(Map<String, AbstractField<?>> headerRowFields) {
        this.headerRowFields.clear();
        this.headerRowFields.putAll(headerRowFields);
        this.headerRowFields.values().forEach(field -> field.setParent(this));
        this.queueCommandIfRendered(() -> new UiTable.SetHeaderRowFieldsCommand(this.getId(), this.headerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference()))));
    }

    public void setHeaderRowField(String columnName, AbstractField<?> field) {
        this.headerRowFields.put(columnName, field);
        this.queueCommandIfRendered(() -> new UiTable.SetHeaderRowFieldsCommand(this.getId(), this.headerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference()))));
    }

    public boolean isShowFooterRow() {
        return this.showFooterRow;
    }

    public void setShowFooterRow(boolean showFooterRow) {
        boolean changed = showFooterRow != this.showFooterRow;
        this.showFooterRow = showFooterRow;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public void setFooterRowBorderWidth(int footerRowBorderWidth) {
        this.setCssStyle(".slick-footerrow", "border-top-width", footerRowBorderWidth + "px");
    }

    public void setFooterRowBorderColor(Color footerRowBorderColor) {
        this.setCssStyle(".slick-footerrow", "border-top-color", footerRowBorderColor != null ? footerRowBorderColor.toHtmlColorString() : null);
    }

    public int getFooterRowHeight() {
        return this.footerRowHeight;
    }

    public void setFooterRowHeight(int footerRowHeight) {
        boolean changed = footerRowHeight != this.footerRowHeight;
        this.footerRowHeight = footerRowHeight;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiTable.UpdateRefreshableConfigCommand(this.getId(), this.createUiRefreshableTableConfigUpdate()));
        }
    }

    public void setFooterRowBackgroundColor(Color footerRowBackgroundColor) {
        this.setCssStyle(".slick-footerrow", "background-color", footerRowBackgroundColor != null ? footerRowBackgroundColor.toHtmlColorString() : null);
    }

    public Map<String, AbstractField<?>> getFooterRowFields() {
        return this.footerRowFields;
    }

    public void setFooterRowFields(Map<String, AbstractField<?>> footerRowFields) {
        this.footerRowFields.clear();
        this.footerRowFields.putAll(footerRowFields);
        this.headerRowFields.values().forEach(field -> field.setParent(this));
        this.queueCommandIfRendered(() -> new UiTable.SetFooterRowFieldsCommand(this.getId(), this.footerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference()))));
    }

    public void setFooterRowField(String columnName, AbstractField<?> field) {
        this.footerRowFields.put(columnName, field);
        this.queueCommandIfRendered(() -> new UiTable.SetFooterRowFieldsCommand(this.getId(), this.footerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiReference()))));
    }

    public <VALUE> TableColumn<RECORD, VALUE> getColumnByPropertyName(String propertyName) {
        return this.columns.stream().filter(column -> column.getPropertyName().equals(propertyName)).map(c -> c).findFirst().orElse(null);
    }

    public AbstractField<?> getHeaderRowFieldByName(String propertyName) {
        return this.headerRowFields.get(propertyName);
    }

    public AbstractField<?> getFooterRowFieldByName(String propertyName) {
        return this.footerRowFields.get(propertyName);
    }

    public List<RECORD> getRecordsWithChangedCellValues() {
        return new ArrayList<RECORD>(this.transientChangesByRecordAndPropertyName.keySet());
    }

    public Map<String, Object> getChangedCellValues(RECORD record) {
        return this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap());
    }

    public Map<String, Object> getAllCellValuesForRecord(RECORD record) {
        Map<String, Object> values = this.extractRecordProperties(record);
        values.putAll(this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap()));
        return values;
    }

    public void clearChangeBuffer() {
        this.transientChangesByRecordAndPropertyName.clear();
    }

    public void applyCellValuesToRecord(RECORD record) {
        Map<String, Object> changedCellValues = this.getChangedCellValues(record);
        changedCellValues.forEach((propertyName, value) -> {
            ValueInjector<Object, Object> columnValueInjector = this.getColumnByPropertyName((String)propertyName).getValueInjector();
            if (columnValueInjector != null) {
                columnValueInjector.inject(record, value);
            } else {
                this.propertyInjector.setValue(record, (String)propertyName, value);
            }
        });
    }

    public void revertChanges() {
        this.transientChangesByRecordAndPropertyName.clear();
        this.refreshData();
    }

    public RECORD getSelectedRecord() {
        return this.selectedRecords.isEmpty() ? null : (RECORD)this.selectedRecords.get(this.selectedRecords.size() - 1);
    }

    public List<RECORD> getSelectedRecords() {
        return this.selectedRecords;
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }

    public PropertyInjector<RECORD> getPropertyInjector() {
        return this.propertyInjector;
    }

    public void setPropertyInjector(PropertyInjector<RECORD> propertyInjector) {
        this.propertyInjector = propertyInjector;
    }

    public Function<RECORD, Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Function<RECORD, Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }

    public List<RECORD> getRenderedRecords() {
        return this.renderedRecords.getRecords();
    }
}

