/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.view;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewChangeHandler;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ViewImpl
implements View {
    private final boolean closable;
    private boolean visible = true;
    private String layoutPosition;
    private ViewSize viewSize;
    private String tabTitle;
    private final Panel panel = new Panel();
    private Toolbar toolbar;
    private final List<ToolbarButtonGroup> workspaceToolbarButtonGroups = new ArrayList<ToolbarButtonGroup>();
    private final List<ViewChangeHandler> changeHandlers = new ArrayList<ViewChangeHandler>();

    public ViewImpl() {
        this.closable = false;
    }

    public ViewImpl(String layoutPosition) {
        this.layoutPosition = layoutPosition;
        this.closable = false;
    }

    public ViewImpl(Icon icon, String title, Component component) {
        this(null, icon, title, component);
    }

    public ViewImpl(String layoutPosition, Icon icon, String title, Component component) {
        this(layoutPosition, icon, title, component, false);
    }

    public ViewImpl(String layoutPosition, Icon icon, String title, Component component, boolean closable) {
        this.layoutPosition = layoutPosition;
        this.panel.setIcon(icon);
        this.panel.setTitle(title);
        this.panel.setContent(component);
        this.closable = closable;
    }

    @Override
    public void addViewChangeHandler(ViewChangeHandler viewChangeHandler) {
        this.changeHandlers.add(viewChangeHandler);
    }

    @Override
    public void removeViewChangeHandler(ViewChangeHandler viewChangeHandler) {
        this.changeHandlers.remove(viewChangeHandler);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleVisibilityChange(visible));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void focus() {
        this.focus(false);
    }

    @Override
    public void focus(boolean ensureVisible) {
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewFocusRequest(ensureVisible));
    }

    @Override
    public ViewSize getCustomViewSize() {
        return this.viewSize;
    }

    @Override
    public void setSize(ViewSize viewSize) {
        this.viewSize = viewSize;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewSizeChange(viewSize));
    }

    @Override
    public ToolbarButtonGroup addLocalButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.checkToolbar();
        this.toolbar.addButtonGroup(buttonGroup);
        return buttonGroup;
    }

    @Override
    public void removeLocalButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.toolbar.removeToolbarButtonGroup(buttonGroup);
    }

    @Override
    public List<ToolbarButtonGroup> getLocalButtonGroups() {
        return this.toolbar.getToolbarButtonGroups();
    }

    private void checkToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
            this.panel.setToolbar(this.toolbar);
        }
    }

    @Override
    public ToolbarButtonGroup addWorkspaceButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.add(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleWorkspaceButtonGroupAdded(buttonGroup));
        return buttonGroup;
    }

    @Override
    public void removeWorkspaceButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.remove(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleWorkspaceButtonGroupRemoved(buttonGroup));
    }

    @Override
    public List<ToolbarButtonGroup> getWorkspaceButtonGroups() {
        return this.workspaceToolbarButtonGroups;
    }

    @Override
    public void setComponent(Component component) {
        this.panel.setContent(component);
    }

    @Override
    public Component getComponent() {
        return this.panel.getContent();
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public boolean isClosable() {
        return this.closable;
    }

    @Override
    public void setLayoutPosition(String position) {
        this.layoutPosition = position;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleLayoutPositionChange(position));
    }

    @Override
    public String getLayoutPosition() {
        return this.layoutPosition;
    }

    @Override
    public void setTitle(String title) {
        this.panel.setTitle(title);
    }

    @Override
    public String getTitle() {
        return this.panel.getTitle();
    }

    @Override
    public void setTabTitle(String title) {
        this.tabTitle = title;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewTabTitleChange(title));
    }

    @Override
    public String getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void setLocalToolbarBackgroundColor(Color color) {
        this.checkToolbar();
        this.toolbar.setBackgroundColor(color);
    }
}

