/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.teamapps.ux.resource.Resource;

public class ByteArrayResource
implements Resource {
    private final byte[] data;
    private final String name;

    public ByteArrayResource(byte[] data, String name) {
        this.data = data;
        this.name = name;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayResource that = (ByteArrayResource)o;
        return Arrays.equals(this.data, that.data) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

