/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.INIT_NOK;
import org.teamapps.dto.INIT_OK;
import org.teamapps.dto.MULTI_CMD;
import org.teamapps.dto.REINIT_NOK;
import org.teamapps.dto.REINIT_OK;
import org.teamapps.dto.UiClientInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.CommandBuffer;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.SessionClosingReason;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.uisession.UnconsumedCommandsOverflowException;

public class TeamAppsUiSessionManager
implements UiCommandExecutor,
HttpSessionListener {
    private static final long UI_SESSION_TIMEOUT = 300000L;
    private ScheduledExecutorService scheduledExecutorService;
    private final ObjectMapper objectMapper;
    private UiSessionListener uiSessionListener;
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsUiSessionManager.class);
    private final Table<String, String, UiSession> sessionsById = Tables.synchronizedTable((Table)HashBasedTable.create());

    public TeamAppsUiSessionManager(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    public TeamAppsUiSessionManager(ObjectMapper objectMapper, UiSessionListener uiSessionListener) {
        this.uiSessionListener = uiSessionListener;
        this.objectMapper = objectMapper;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.removeTimedOutSessions(300000L), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    public void setUiSessionListener(UiSessionListener uiSessionListener) {
        this.uiSessionListener = uiSessionListener;
    }

    private UiSession getSessionById(QualifiedUiSessionId sessionId) {
        return (UiSession)this.sessionsById.get((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSession(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, int maxRequestedCommandId, MessageSender messageSender) {
        UiSession session;
        LOGGER.trace("initSession: sessionId = [" + sessionId + "], clientInfo = [" + clientInfo + "], maxRequestedCommandId = [" + maxRequestedCommandId + "], messageSender = [" + messageSender + "]");
        boolean isRefresh = false;
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            if (this.sessionsById.contains((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId())) {
                isRefresh = true;
                session = this.getSessionById(sessionId);
            } else {
                session = new UiSession(sessionId, clientInfo, System.currentTimeMillis(), this.uiSessionListener, messageSender);
                this.sessionsById.put((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId(), (Object)session);
            }
        }
        if (isRefresh) {
            if (session != null) {
                session.handleClientRefresh(maxRequestedCommandId, messageSender);
            } else {
                messageSender.sendMessageAsynchronously((AbstractServerMessage)new INIT_NOK(INIT_NOK.Reason.SESSION_NOT_FOUND), null);
            }
        } else {
            session.init(maxRequestedCommandId);
        }
    }

    public void handleEvent(QualifiedUiSessionId sessionId, int clientMessageId, UiEvent event) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleEvent(clientMessageId, event);
    }

    public void handleCommandResult(QualifiedUiSessionId sessionId, int clientMessageId, int cmdId, Object result) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleCommandResult(clientMessageId, cmdId, result);
    }

    public void handleKeepAlive(QualifiedUiSessionId sessionId) {
        UiSession session = this.getSessionById(sessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(sessionId);
        }
        session.handleKeepAlive();
    }

    public void reinitSession(QualifiedUiSessionId sessionId, int lastReceivedCommandId, int maxRequestedCommandId, MessageSender messageSender) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            session.reinit(lastReceivedCommandId, maxRequestedCommandId, messageSender);
        } else {
            LOGGER.warn("Could not find teamAppsUiSession for REINIT: " + sessionId);
            messageSender.sendMessageAsynchronously((AbstractServerMessage)new REINIT_NOK(REINIT_NOK.Reason.SESSION_NOT_FOUND), null);
        }
    }

    public void handleCommandRequest(QualifiedUiSessionId qualifiedUiSessionId, int lastReceivedCommandId, int maxRequestedCommandId) {
        UiSession session = this.getSessionById(qualifiedUiSessionId);
        if (session == null) {
            throw new TeamAppsSessionNotFoundException(qualifiedUiSessionId);
        }
        session.handleCommandRequest(lastReceivedCommandId, maxRequestedCommandId);
    }

    public void sendCommand(QualifiedUiSessionId sessionId, UiCommandWithResultCallback commandWithCallback) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            try {
                session.sendCommand(commandWithCallback);
            }
            catch (UnconsumedCommandsOverflowException e) {
                LOGGER.error("Too many unconsumed commands!", (Throwable)e);
                this.closeSession(sessionId, SessionClosingReason.COMMANDS_OVERFLOW);
            }
        } else {
            LOGGER.warn("Cannot send command to non-existing session: " + sessionId);
        }
    }

    @Override
    public void sendCommands(QualifiedUiSessionId sessionId, List<UiCommandWithResultCallback> commandsWithCallback) {
        UiSession session = this.getSessionById(sessionId);
        if (session != null) {
            try {
                ArrayList<UiCommandWithResultCallback> uiCommandsCopy = new ArrayList<UiCommandWithResultCallback>(commandsWithCallback);
                session.sendCommands(uiCommandsCopy);
            }
            catch (UnconsumedCommandsOverflowException e) {
                LOGGER.error("Too many unconsumed commands!", (Throwable)e);
                this.closeSession(sessionId, SessionClosingReason.COMMANDS_OVERFLOW);
            }
        } else {
            LOGGER.warn("Cannot send commands to non-existing session: " + sessionId);
        }
    }

    public void closeSession(QualifiedUiSessionId sessionId, SessionClosingReason reason) {
        if (this.sessionsById.remove((Object)sessionId.getHttpSessionId(), (Object)sessionId.getUiSessionId()) != null) {
            LOGGER.info("Actively closing session: " + sessionId);
            this.uiSessionListener.onUiSessionClosed(sessionId, reason);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.removeAllSessionsForHttpSession(se.getSession().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSessionsForHttpSession(String httpSessionId) {
        ArrayList removedSessions;
        LOGGER.trace("TeamAppsUiSessionManager.removeAllSessionsForHttpSession");
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            Map sessionsToBeClosed = this.sessionsById.row((Object)httpSessionId);
            removedSessions = new ArrayList(sessionsToBeClosed.values());
            sessionsToBeClosed.clear();
        }
        removedSessions.forEach(session -> {
            LOGGER.info("Removed session since HTTP session was closed: " + ((UiSession)session).sessionId);
            this.uiSessionListener.onUiSessionClosed(((UiSession)session).sessionId, SessionClosingReason.HTTP_SESSION_CLOSED);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedOutSessions(long timeoutMilliSeconds) {
        ArrayList removedSessions;
        long now = System.currentTimeMillis();
        Table<String, String, UiSession> table = this.sessionsById;
        synchronized (table) {
            removedSessions = new ArrayList();
            this.sessionsById.values().removeIf(session -> {
                boolean isTimedOut;
                boolean bl = isTimedOut = now - session.getTimestampOfLastMessageFromClient() > timeoutMilliSeconds;
                if (isTimedOut) {
                    LOGGER.debug("UI session timed out after " + timeoutMilliSeconds + " ms: " + ((UiSession)session).sessionId);
                    removedSessions.add(session);
                }
                return isTimedOut;
            });
        }
        removedSessions.forEach(session -> {
            LOGGER.info("Session timeout: " + ((UiSession)session).sessionId);
            this.uiSessionListener.onUiSessionClosed(((UiSession)session).sessionId, SessionClosingReason.TIMED_OUT);
        });
    }

    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    private class UiSession {
        private static final int COMMAND_BUFFER_SIZE = 10000;
        private final QualifiedUiSessionId sessionId;
        private final UiClientInfo clientInfo;
        private final UiSessionListener sessionListener;
        private MessageSender messageSender;
        private final CommandBuffer commandBuffer = new CommandBuffer(10000);
        private AtomicInteger commandIdCounter = new AtomicInteger();
        private AtomicLong timestampOfLastMessageFromClient = new AtomicLong();
        private int lastReceivedClientMessageId;
        private boolean connectionActive = true;
        private int maxRequestedCommandId = 0;
        private int lastSentCommandId;
        private Map<Integer, Consumer> resultCallbacksByCmdId = new ConcurrentHashMap<Integer, Consumer>();

        public UiSession(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, long creationTime, UiSessionListener sessionListener, MessageSender messageSender) {
            this.sessionId = sessionId;
            this.clientInfo = clientInfo;
            this.timestampOfLastMessageFromClient.set(creationTime);
            this.sessionListener = sessionListener;
            this.messageSender = messageSender;
        }

        public long getTimestampOfLastMessageFromClient() {
            return this.timestampOfLastMessageFromClient.get();
        }

        public void setMessageSender(MessageSender messageSender) {
            this.messageSender = messageSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendCommand(UiCommandWithResultCallback commandWithCallback) throws UnconsumedCommandsOverflowException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending command ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)commandWithCallback.getUiCommand().getClass().getSimpleName());
            }
            CMD cmd = this.createCMD(commandWithCallback);
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.commandBuffer.addCommand(cmd);
                this.sendAllQueuedCommandsIfPossible();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendCommands(List<UiCommandWithResultCallback> commandsWithCallback) throws UnconsumedCommandsOverflowException {
            if (LOGGER.isDebugEnabled()) {
                commandsWithCallback.stream().map(UiCommandWithResultCallback::getUiCommand).forEach(command -> LOGGER.debug("Sending command ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)command.getClass().getSimpleName()));
            }
            List cmds = commandsWithCallback.stream().map(commandWithCallback -> this.createCMD((UiCommandWithResultCallback)commandWithCallback)).collect(Collectors.toList());
            UiSession uiSession = this;
            synchronized (uiSession) {
                for (CMD cmd : cmds) {
                    this.commandBuffer.addCommand(cmd);
                }
                this.sendAllQueuedCommandsIfPossible();
            }
        }

        private CMD createCMD(UiCommandWithResultCallback commandWithCallback) {
            CMD cmd;
            try {
                int cmdId = this.commandIdCounter.incrementAndGet();
                cmd = new CMD(cmdId, TeamAppsUiSessionManager.this.objectMapper.writeValueAsString(commandWithCallback.getUiCommand()));
                if (commandWithCallback.getResultCallback() != null) {
                    cmd.setAwaitsResponse(true);
                    this.resultCallbacksByCmdId.put(cmdId, commandWithCallback.getResultCallback());
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rewindToCommand(int commandId) {
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.lastSentCommandId = commandId - 1;
                return this.commandBuffer.rewindToCommand(commandId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendAllQueuedCommandsIfPossible() {
            if (this.connectionActive) {
                ArrayList<CMD> cmdsToSend = new ArrayList<CMD>();
                UiSession uiSession = this;
                synchronized (uiSession) {
                    while (true) {
                        if (this.lastSentCommandId >= this.maxRequestedCommandId) {
                            this.connectionActive = false;
                            break;
                        }
                        CMD cmd = this.commandBuffer.consumeCommand();
                        if (cmd == null) break;
                        this.lastSentCommandId = cmd.getId();
                        cmdsToSend.add(cmd);
                    }
                }
                if (!cmdsToSend.isEmpty()) {
                    this.sendAsyncWithErrorHandler((AbstractServerMessage)new MULTI_CMD(cmdsToSend));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reviveConnection() {
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.connectionActive = true;
                this.sendAllQueuedCommandsIfPossible();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCommandRequest(int lastReceivedCommandId, int maxRequestedCommandId) {
            LOGGER.trace("UiSession.requestCommands: maxRequestedCommandId = [" + maxRequestedCommandId + "]");
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.commandBuffer.purgeTillCommand(lastReceivedCommandId);
                this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
                this.reviveConnection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(int maxRequestedCommandId) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.maxRequestedCommandId = maxRequestedCommandId;
            }
            LOGGER.debug("INIT successful: " + this.sessionId);
            this.sessionListener.onUiSessionStarted(this.sessionId, this.clientInfo);
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new INIT_OK());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClientRefresh(int maxRequestedCommandId, MessageSender messageSender) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            UiSession uiSession = this;
            synchronized (uiSession) {
                this.messageSender = messageSender;
                this.commandBuffer.clear();
                this.commandIdCounter.set(0);
                this.lastReceivedClientMessageId = -1;
                this.connectionActive = true;
                this.maxRequestedCommandId = maxRequestedCommandId;
                this.lastSentCommandId = 0;
            }
            LOGGER.debug("INIT (client refresh) successful: " + this.sessionId);
            this.sessionListener.onUiSessionClientRefresh(this.sessionId, this.clientInfo);
            this.sendAsyncWithErrorHandler((AbstractServerMessage)new INIT_OK());
        }

        public void handleEvent(int clientMessageId, UiEvent event) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recieved event ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8), (Object)event.getUiEventType());
            }
            this.updateClientMessageId(clientMessageId);
            this.reviveConnection();
            this.sessionListener.onUiEvent(this.sessionId, event);
        }

        public void handleCommandResult(int clientMessageId, int cmdId, Object result) {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recieved command result ({}): {}", (Object)this.sessionId.getUiSessionId().substring(0, 8));
            }
            this.updateClientMessageId(clientMessageId);
            this.reviveConnection();
            Consumer resultCallback = this.resultCallbacksByCmdId.remove(cmdId);
            if (resultCallback != null) {
                resultCallback.accept(result);
            } else {
                LOGGER.error("Could not find result callback for CMD_RESULT! cmdId: " + cmdId);
            }
        }

        private void updateClientMessageId(int clientMessageId) {
            if (this.lastReceivedClientMessageId != -1 && clientMessageId != this.lastReceivedClientMessageId + 1) {
                LOGGER.warn("Missing event from client? Expected event id: " + this.lastReceivedClientMessageId + "1; Got: " + clientMessageId);
            }
            this.lastReceivedClientMessageId = clientMessageId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int lastReceivedCommandId, int maxRequestedCommandId, MessageSender messageSender) {
            this.setMessageSender(messageSender);
            if (this.rewindToCommand(lastReceivedCommandId)) {
                LOGGER.debug("REINIT successful: " + this.sessionId);
                UiSession uiSession = this;
                synchronized (uiSession) {
                    this.maxRequestedCommandId = Math.max(maxRequestedCommandId, this.maxRequestedCommandId);
                }
                this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_OK(this.lastReceivedClientMessageId));
                this.reviveConnection();
            } else {
                LOGGER.warn("Could not reinit. Command with id " + lastReceivedCommandId + "not found in command buffer.");
                this.sendAsyncWithErrorHandler((AbstractServerMessage)new REINIT_NOK(REINIT_NOK.Reason.COMMAND_ID_NOT_FOUND));
            }
        }

        private void sendAsyncWithErrorHandler(AbstractServerMessage message) {
            long sendTime = System.currentTimeMillis();
            this.messageSender.sendMessageAsynchronously(message, exception -> {
                if (this.timestampOfLastMessageFromClient.get() <= sendTime) {
                    this.connectionActive = false;
                }
            });
        }

        public void handleKeepAlive() {
            this.timestampOfLastMessageFromClient.set(System.currentTimeMillis());
            this.reviveConnection();
        }
    }
}

